% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGDrivE-Auxiliary.R
\name{getOmega}
\alias{getOmega}
\title{Solve for Omega (additional genotype-specific mortality)}
\usage{
getOmega(mu, lifespanReduction)
}
\arguments{
\item{mu}{daily mortality probability (discrete-time hazard, called \code{muAd} in code)}

\item{lifespanReduction}{percent reduction in lifespan from average lifespan
(target average lifespan will be \eqn{\frac{1}{\mu_{Ad}} \times lifespanReduction})}
}
\description{
Solves for root of equation of geometrically-distributed lifespan for value of omega.
}
\examples{
# reduce lifespan by 10\%
#  Example mu is an average for Aedes
newOmega <- getOmega(mu = 0.11, lifespanReduction = 0.90)

}
