% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Patch-Methods.R
\name{set_initialPopulation_Patch}
\alias{set_initialPopulation_Patch}
\title{Set Initial Population}
\usage{
set_initialPopulation_Patch(
  adultEQ = adultEQ,
  larvalEQ = larvalEQ,
  adultRatioF = adultRatioF,
  adultRatioM = adultRatioM,
  larvalRatio = larvalRatio,
  timeAq = timeAq,
  muAq = muAq,
  alpha = alpha
)
}
\arguments{
\item{adultEQ}{Equilibrium number of adults}

\item{larvalEQ}{Equilibrium number of larvae}

\item{adultRatioF}{Genotype specific ratio for adult females}

\item{adultRatioM}{Genotype specific ratio for adult males}

\item{larvalRatio}{Genotype specific ratio for larvae}

\item{timeAq}{Time for each aquatic stage}

\item{muAq}{Aquatic death rate}

\item{alpha}{Density-dependent centering parameter}
}
\description{
This hidden function distributes the population at time 0 in the steady-state
conformation. This involves finding the number of mosquitoes in each day of the
aquatic stages, and then splitting adults into male and female. Each stage is
appropriately split amongst the initial population genotypes (see \code{\link{parameterizeMGDrivE}}).
It internally calls \code{\link{calcLarvalDist}} to determine the distribution
of larvae before setting the eggs and pupa from that.
}
