% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling-trajectory-CSV.R
\name{sim_trajectory_CSV}
\alias{sim_trajectory_CSV}
\title{Simulate Trajectory From a SPN Model}
\usage{
sim_trajectory_CSV(
  x0,
  t0 = 0,
  tt = 100,
  dt = 1,
  dt_stoch = 0.1,
  folders = "./",
  stage = c("M", "F"),
  S,
  hazards,
  Sout = NULL,
  sampler = "tau",
  method = "lsoda",
  events = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x0}{the initial marking of the SPN (initial state, M0)}

\item{t0}{initial time to begin simulation}

\item{tt}{the final time to end simulation}

\item{dt}{the time-step at which to return output (\strong{not} the time-step of the sampling algorithm)}

\item{dt_stoch}{time-step used for approximation of hazards}

\item{folders}{vector of folders to write output}

\item{stage}{life-stages to print. Any combination of: "E", "L", "P"," M", "U", "F", "H"}

\item{S}{a stoichiometry \code{\link[Matrix]{Matrix-class}} object}

\item{hazards}{list of hazard functions}

\item{Sout}{an optional matrix to track event firings}

\item{sampler}{determines sampling algorithm, one of; "ode", "tau", "cle", or "dm"}

\item{method}{if \code{sampler} is "ode", the solver to use, from \code{deSolve}}

\item{events}{a \code{data.frame} of events}

\item{verbose}{print a progress bar?}

\item{...}{further named arguments passed to the step function}
}
\value{
NULL - prints output to .csv files
}
\description{
This function provides a unified interface to the various simulation algorithms
for SPN, returning output sampled at a lattice of time points to the user, and
handling various exogenous events that may occur during the simulation
(such as release of adult mosquitoes).
}
\details{
\code{dt_stoch} is used by the Poisson Time-Step (\code{\link{step_PTS}}) and
Chemical Langevin (\code{\link{step_CLE}}) methods to approximate the hazards.
A smaller \code{dt_stoch} provides a better approximation, but will take longer
to run.

The stoichiometry matrix (\code{S}) is generated in \code{\link{spn_S}}.

The list of hazards (\code{hazards}) come from \code{\link{spn_hazards}}.

Several samplers are provided. The default is a Poisson Time-Step
(\code{\link{step_PTS}}) method. Other options are Gillespie's Direct Method
(\code{\link{step_DM}}) and a Chemical Langevin sampler (\code{\link{step_CLE}}).
Additionally, for convenience, an ODE "sampler" (\code{\link{step_ODE}}) is
provided for compatibility with other samplers. This function uses methods from
\code{deSolve}.

If using the \code{ode} sampler, several \code{methods} are provided in the \code{deSolve}
package, see \code{\link[deSolve]{ode}}. For inhomogeneous systems, consider
using the "rk4" method to avoid excessive integration times.

Additionally, \code{events} objects must follow the format required by
\code{deSolve}. This was done for consistency, see \code{\link[deSolve]{events}}
for more information.

This function writes all output to .csv files. Each simulation is written to
a \code{folder} element - the number of repetitions is the number of folders
provided. What life-stages get recorded is specified by the \code{stage} parameter.
All life-stages can be stored, or any subset thereof. Females are split by
infection status, i.e. by "S", "E", or "I".

This function tracks state variables specified by argument \code{stage} by default; an optional argument \code{Sout}
can be provided to track number of event firings each time step (for discrete stochastic simulations),
or cumulative intensity (for continuous stochastic simulations), or the rate function of
particular events for ODE simulation. The matrix must have number of columns equal to
number of events in the system (the number of hazard functions), and a row for each tracking
variable. If \code{Sout} is provided, it output an additional csv, "events.csv".
The function \code{\link{track_hinf}} is provided, which builds a matrix to track
human infection events.

To return simulations to R for further processing, see \code{\link{sim_trajectory_R}}.
}
