% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{clip_data}
\alias{clip_data}
\title{Clip dataframe to the given start and stop time}
\usage{
clip_data(df, start_time, stop_time)
}
\arguments{
\item{df}{dataframe. Input dataframe of the multi-channel signal. The first
column is the timestamps in POSXlct format and the following columns are
accelerometer values.}

\item{start_time}{POSXlct format or character. Start time for clipping.
If it is a character, it should be recognizable by as.POSXlct function.}

\item{stop_time}{POSXlct format or character. Stop time for clipping.
If it is a character, it should be recognizable by as.POSXlct function.}
}
\value{
dataframe. The same format as the input dataframe.
}
\description{
\code{clip_data} clips the input sensor dataframe according to the given
start and stop time
}
\details{
This function accepts a dataframe of multi-channel signal, clips it
according to the start_time and stop_time.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a utility
  function that was used in various part in the algorithm whenever we need to
  clip a dataframe.
}

\examples{
  default_ops = options()
  options(digits.secs=3)
  # Use the provided sample data
  df = sample_raw_accel_data

  # Check the start time and stop time of the dataset
  summary(df)

  # Use timestamp string to clip 1 second data
  start_time = "2016-01-15 11:01:00"
  stop_time = "2016-01-15 11:01:01"
  output = clip_data(df, start_time, stop_time)
  summary(output)

  # Use POSIXct timestamp to clip data
  start_time = as.POSIXct("2016-01-15 11:01:00")
  stop_time = as.POSIXct("2016-01-15 11:01:01")
  output = clip_data(df, start_time, stop_time)
  summary(output)

  # If start and stop time is not in the range of the input data
  # return empty data.frame
  start_time = "2016-01-15 12:01:00"
  stop_time = "2016-01-15 12:01:01"
  output = clip_data(df, start_time, stop_time)
  output

  # Restore original options
  options(default_ops)
}
\seealso{
Other utility functions: 
\code{\link{cut_off_signal}()},
\code{\link{interpolate_signal}()},
\code{\link{parse_epoch_string}()},
\code{\link{sampling_rate}()},
\code{\link{segment_data}()},
\code{\link{simulate_new_data}()}
}
\concept{utility functions}
