% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_pfi}
\alias{plot_pfi}
\title{Plotting Permutation Feature Importance Barplot}
\usage{
plot_pfi(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'sensitivity_analysis(methods = "PFI")'.}

\item{show_table}{Boolean. Whether to print PFI results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_pfi()} function generates bar plots to visualize feature importance through permutation,
providing clear representation of each predictor variable's relative contribution to model performance.
The function includes an option to display accompanying numerical results tables for comprehensive
interpretation.
}
\examples{
# Note: For obtaining the PFI plot results the user needs to complete till
# sensitivity_analysis( ) function of the MLwrap pipeline using the PFI method.

\dontrun{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Grid Search CV")
wrap_object <- sensitivity_analysis(wrap_object, methods = "PFI")

# And then, you can obtain the PFI plot.

plot_pfi(wrap_object)

}

}
