% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_install_launcher.R
\name{install_MODIStsp_launcher}
\alias{install_MODIStsp_launcher}
\title{install_MODIStsp_launcher}
\usage{
install_MODIStsp_launcher(bin_dir = NA, desktop_dir = NA,
  desktop_shortcut = TRUE, sudo = FALSE)
}
\arguments{
\item{bin_dir}{in Linux, directory in which the link to the bash script should be
placed (default: /usr/bin; a path included in the PATH environment variable is
suggested); in Windows, directory where to place the menu entry in the Start Menu
(default: Start Menu -> Programs -> MODIStsp).}

\item{desktop_dir}{if desktop_shortcut=TRUE: in Linux, directory in which the desktop
entry should be placed (default: /usr/share/applications); in Windows, directory where
to place the desktop entry (default: Desktop).}

\item{desktop_shortcut}{logical value which indicates if the desktop entry or the
desktop shortcut should be created (default: TRUE).}

\item{sudo}{(Linux only) logical value which indicates if administrator rights have to
be used to write within bin_dir and desktop_dir (default: FALSE);
in this case, the root password is requested when launching the function. Note that
default values of bin_dir and desktop_dir requires to set this option to TRUE (or to
launch the script in a root session of R)!}
}
\description{
Function which allows to use MODIStsp in batch mode by creating links
}
\details{
MODIStsp tool can be used also as a standalone tool my launching a bash/batch
script, which is stored in the function files. In order to simply retrieve it, this
function will create a desktop entry and a symbolic link to the bash script (in Linux)
or a link in the Start Menu to the batch script (in Windows).
Note that, if the packages MODIStsp is installed in a version-dependent directory
(as the default one is), this function should be re-executed after an R upgrade,
otherwise the links would continue to point to the old package version!
}
\note{
License: GPL 3.0
}
\examples{
# Linux: common installation (script in /usr/bin,
# desktop entry in /usr/share/applications)
# (requires administrator permissions)
\dontrun{
install_MODIStsp_launcher(sudo = TRUE)
  # the administrator password is asked interactively}

# Linux: installation in a directory which does
# not require administrator permissions
\dontrun{
install_MODIStsp_launcher(bin_dir = "~/bin"), desktop_dir = "~/Desktop"}

# Windows: common installation
# (script in the Start Menu and shortcut on the desktop)
\dontrun{
install_MODIStsp_launcher()}
}
\author{
Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
