% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_process_bands.R
\name{MODIStsp_process_bands}
\alias{MODIStsp_process_bands}
\title{MODIStsp helper for processing original HDF layers}
\usage{
MODIStsp_process_bands(out_folder_mod, modislist, outproj_str,
  mod_proj_str, sens_sel, band, bandname, date_name, datatype, nodata_in,
  nodata_out, full_ext, bbox, scale_val, scale_factor, offset, out_format,
  outrep_file, compress, out_res_sel, out_res, resampling, gui, mess_lab,
  verbose)
}
\arguments{
\item{out_folder_mod}{\code{character} Output folder for original HDF storage.}

\item{modislist}{\code{character array} List of MODIS images to be downloaded for
the selected date (as returned from \code{get_mod_filenames}). Can be a single
image, or a list of images in case different tiles are needed!}

\item{outproj_str}{\code{character} proj4 string of selected output projection.}

\item{mod_proj_str}{\code{character} proj4 string of MODIS product native projection.}

\item{sens_sel}{\code{character ["terra" | "aqua"]} Selected sensor.}

\item{band}{\code{numeric} band number corresponding to the HDF layer to be
processed}

\item{bandname}{\code{character} Name to the HDF layer to be processed.}

\item{date_name}{\code{character} Date of acquisition of the images to be
downloaded.}

\item{datatype}{\code{character} Datatype to the HDF layer to be processed.}

\item{nodata_in}{\code{numeric} Original nodata value to the HDF layer to be
processed.}

\item{nodata_out}{\code{numeric} Output nodata value to the HDF layer to be
processed.}

\item{full_ext}{\code{characrter ["FullTiles" | "Resized"]} If "Full_Ext", process
the entire extent of the selected tiles. Otherwise, crop the output to
output bbox.}

\item{bbox}{\code{numeric(4)} Output bounding box (xmin, ymin, xmax, ymax) in
out_proj coordinate system.}

\item{scale_val}{\code{character ["Yes" | "No"]} If == "Yes", scale and offset are applied to
original MODIS layers, and Spectral Indexes are saved as floating point. If
== "No", no rescaling is done and Spectral Indexes are saved as integer, with a
10000 scaling factor.}

\item{scale_factor}{\code{numeric} Scale factor to be applied to the HDF layer
to be processed (Ignored if \code{scale_val} == FALSE).}

\item{offset}{\code{numeric} Offset to be applied to the HDF layer
to be processed (Ignored if \code{scale_val} == FALSE).}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Desired output format.}

\item{outrep_file}{\code{character} Full path of the file where results of the
processing are to be stored (created in \code{MODIStsp_process})}

\item{compress}{\code{character ["None" | "PACKBITS" | "LZW" | "DEFLATE"]}
Compression method for GTiff outputs (Ignored if \code{out_format == ENVI})}

\item{out_res_sel}{\code{character ["Native" | "Resampled"]} Indicates if the native
resolution of the product or a user supplied one is to be used.}

\item{out_res}{\code{float} Output resolution (in output projection measurement
unit). Ignored if out_res_sel == "Native".}

\item{resampling}{\code{character ["near" | "bilinear" | "cubic" | "lanczos" | "mode"]}
Resampling method to be used by \code{gdalwarp}.}

\item{gui}{\code{logical} Indicates if processing was called starting from an
interactive environment or not. If FALSE, processing messages are sent to a
log file instead than to the console, and gWidgets messages are suppressed}

\item{mess_lab}{Pointer to the gWidget used to visualize processing messages
in interactive execution.}

\item{verbose}{\code{logical} If FALSE, suppress processing messages, Default: TRUE}
}
\value{
The function is called for its side effects
}
\description{
Internal function used to perform the required spatial
processing on MODIS original hdf layers (reprojection, resizing, resampling,
mosaicing, computation of scaling factors). The function is based on the
use of \code{gdal} routines.
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{lbusett@gmail.com}

Luigi Ranghetti, phD (2015) \email{ranghetti.l@irea.cnr.it}
}
