% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moss_select.R
\name{moss_select}
\alias{moss_select}
\title{Returns features and subject selected by latent dimension.}
\usage{
moss_select(data.blocks, SVD, resp.block = NULL, K = NULL, plot = FALSE)
}
\arguments{
\item{data.blocks}{a list of omic blocks as provided to moss.}

\item{SVD}{a list with SVD results. The function is meant to work
with the results from sparse SVD. 
However, 'dense' solutions are also accepted.}

\item{resp.block}{Which omic block was used as response in moss? 
Integer. Defaults to NULL.}

\item{K}{How many dimensions should be displayed? Vector.
Defaults to the 1 : ncol(SVD$v).}

\item{plot}{Should the results be plotted? Logical. 
Defaults to FALSE}
}
\value{
Returns a list containing the position, name, and loadings
of selected features and subjects by latent dimension.
if 'plot=TRUE', a scatterplot is displayed, where the x-axis
represents the latent dimensions, the y-axis the total number 
of features selected in log scale, and each point is a pie chart
showing the relative contribution of each omic to the number of
features selected. The radio of the pie chart represents the 
coefficient of variation among squared loadings 
(mean squared loadings divided by their standard deviation).
}
\description{
This function is meant to used after moss.
Its main purpose is to extract the features and subjects by 
latent dimension.
The selection depends on loadings at each dimension being 
different from zero.
}
