% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRMCbinary.R
\name{MRMCbinary}
\alias{MRMCbinary}
\title{Multi-reader multi-case analysis of binary diagnostic tests}
\usage{
MRMCbinary(
  data,
  Modality,
  Reader,
  Case,
  D,
  Y,
  effect,
  interaction = NULL,
  reference.Modality = NULL,
  reference.Reader = NULL
)
}
\arguments{
\item{data}{A data frame in which contains the modality identifiers (\code{Modality}), the reader identifiers (\code{Reader}), the case identifiers (\code{Case}), the true disease status (\code{D}), and the binary diagnostic test result (\code{Y}).}

\item{Modality}{Variable of the modality identifiers.}

\item{Reader}{Variable of the reader identifiers.}

\item{Case}{Variable of the case identifiers.}

\item{D}{Variable of the true disease status. It should be set the value to 1 for cases diseased and to 0 for those non-diseased.}

\item{Y}{Variable of the binary diagnostic test result. It should be set the value to 1 for cases diagnosed as positive and to 0 for those diagnosed as negative.}

\item{effect}{Effect to compare sensitivity and specificity (one of \code{"Modality"}, \code{"Reader"}, and \code{"Both"}). See \bold{Details}.}

\item{interaction}{When evaluating the interaction effect between modality and reader, \code{interaction = TRUE}, otherwise \code{interaction = FALSE}. Specify only when \code{effect} is \code{"Both"}. Default: \code{NULL}. See \bold{Details}.}

\item{reference.Modality}{Reference in variable of the modality identifiers.}

\item{reference.Reader}{Reference in variable of the reader identifiers.}
}
\value{
An object of class \code{MRMCbinary}. The object is a data.frame with the following components:
\item{CLR_sen}{Conditional logistic regression results for sensitivity.}
\item{CLR_LRT_sen}{Likelihood ratio test from the conditional logistic regression results for sensitivity.}
\item{CLR_Score_sen}{Score test from the conditional logistic regression results for sensitivity.}
\item{CLR_Wald_sen}{Wald test from the conditional logistic regression results for sensitivity.}
\item{Q_MN_sen}{Cochran's Q test (when the number of modalities is greater than 2) or McNemar's test (when the number of modalities is equal to 2) result for sensitivity. This is only reported if (1) \code{effect = "Modality"}, (2) \code{effect = "Reader"}, or (3) \code{effect = "Both"} and \code{interaction = TRUE}.}
\item{CLR_spe}{Conditional logistic regression results for specificity.}
\item{CLR_LRT_spe}{Likelihood ratio test from the conditional logistic regression results for specificity.}
\item{CLR_Score_spe}{Score test from the conditional logistic regression results for specificity.}
\item{CLR_Wald_spe}{Wald test from the conditional logistic regression results for specificity.}
\item{Q_MN_spe}{Cochran's Q test (when the number of modalities is greater than 2) or McNemar's test (when the number of modalities is equal to 2) result for specificity. This is only reported if (1) \code{effect = "Modality"}, (2) \code{effect = "Reader"}, or (3) \code{effect = "Both"} and \code{interaction = TRUE}.}
\item{formula}{Formula used in the conditional logistic regression.}
\item{args}{List of arguments used in the \code{MRMCbinary} function.}
\item{n.modality}{Total number of modalities.}
\item{n.reader}{Total number of readers.}
\item{n.case}{Total number of cases.}
\item{effect}{Effect to compare sensitivity and specificity.}
\item{interaction}{This is only included in the \code{MRMCbinary} object when \code{effect = "Both"}. If one want to evaluate the interaction effect between modality and reader in the conditional logistic regression, \code{interaction = TRUE}, otherwise \code{interaction = FALSE}.}
\item{reference.Modality}{Reference in variable of the modality identifiers.}
\item{reference.Reader}{Reference in variable of the reader identifiers.}
The results for the \code{MRMCbinary} are printed with the \code{\link[MRMCbinary]{print.MRMCbinary}} function.
Also, the results for the \code{MRMCbinary} are summarized with the \code{\link[MRMCbinary]{summary.MRMCbinary}} function.
}
\description{
\code{MRMCbinary()} is the main function of \code{MRMCbinary} package and
can be used to compare sensitivity and specificity of diagnostic tests for binary outcomes in multi-reader multi-case (MRMC) studies.
}
\details{
There are three effects that can be evaluated:
\itemize{
\item \code{effect = "Modality"}: This is used when the goal is to exclusively evaluate the effects of multiple modalities.
And, Cochran's Q test (when the number of modalities is greater than 2) or McNemar's test (when the number of modalities is equal to 2) result is reported.
When \code{effect = "Modality"}, \code{interaction} must be set to NULL.
\item \code{effect = "Reader"}: This is used when the goal is to exclusively evaluate the effects of multiple readers.
And, Cochran's Q test (when the number of modalities is greater than 2) or McNemar's test (when the number of modalities is equal to 2) result is reported.
When \code{effect = "Reader"}, \code{interaction} must be set to NULL.
\item \code{effect = "Both"}: This is used when the goal is to simultaneously evaluate the effects of multiple modalities and multiple readers.
In this case, \code{interaction} must be specified (TRUE or FALSE).
If one want to evaluate the interaction effect between modality and reader in the conditional logistic regression, set \code{interaction = TRUE}, otherwise \code{interaction = FALSE}.
When \code{interaction = TRUE}, Cochran's Q test result is reported.
However, when \code{interaction = FALSE}, Cochran's Q test or McNemar's test result is not reported.
}

See Lee et al. (2025) for details.
}
\examples{
## Load example data
data(VanDyke)

## Return the first parts of an object
head(VanDyke)

## See unique readers
unique(VanDyke$reader)

## See unique modalities
unique(VanDyke$treatment)

## Create binary test results (Y_ijk)
VanDyke$Y <- as.numeric(VanDyke$rating >= 3)

## Example usage of MRMCbinary function:
# When comparing the sensitivities and specificities between modalities
modality_result <- MRMCbinary(data = VanDyke, Modality = treatment, Reader = reader,
                              Case = case, D = truth, Y = Y, effect = "Modality",
                              interaction = NULL,
                              reference.Modality = "1", reference.Reader = NULL)

# When comparing the sensitivities and specificities between readers
reader_result <- MRMCbinary(data = VanDyke, Modality = treatment, Reader = reader,
                            Case = case, D = truth, Y = Y, effect = "Reader",
                            interaction = NULL,
                            reference.Modality = NULL, reference.Reader = "1")

# When comparing the sensitivities and specificities
#  between modalities and between readers together
#  not considering interaction between modalities and readers
both_result_wo_int <- MRMCbinary(data = VanDyke, Modality = treatment, Reader = reader,
                                 Case = case, D = truth, Y = Y, effect = "Both",
                                 interaction = FALSE,
                                 reference.Modality = "1", reference.Reader = "1")

# When comparing the sensitivities and specificities
#  between modalities and between readers together
#  considering interaction between modalities and readers
both_result_with_int <- MRMCbinary(data = VanDyke, Modality = treatment, Reader = reader,
                                   Case = case, D = truth, Y = Y, effect = "Both",
                                   interaction = TRUE,
                                   reference.Modality = "1", reference.Reader = "1")

}
\references{
Lee, S., Jang, S., and Lee, W. Evaluating Diagnostic Accuracy of Binary Medical Tests in Multi-reader Multi-case Study.
}
\seealso{
\code{\link[MRMCbinary]{print.MRMCbinary}}, \code{\link[MRMCbinary]{summary.MRMCbinary}}
}
\keyword{methods}
