% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableOverview.R
\name{tableOverview}
\alias{tableOverview}
\title{Data Types and Dimensions}
\usage{
tableOverview(channel, sqtable, max = 1000)
}
\arguments{
\item{channel}{an RODBC connection.}

\item{sqtable}{a database table or view.}

\item{max}{number of rows to analyze the resulting data frame columns in R.
Pass \code{max = 0} to analyze the entire database table.}
}
\value{
List containing \code{Cols} and \code{Rows}, describing column data types and
the number of rows.
}
\description{
Show data types and dimensions of a database table.
}
\examples{
\dontrun{
con <- odbcConnect("myDatabase")

tableOverview(con, "sysusers")

tableOverview(con, "sysusers")$Cols
}

}
\seealso{
\code{\link{sqlColumns}}, \code{\link{sqlQuery}}, and \code{\link{tableNrow}}
are the underlying functions used to examine the table/view.

\code{\link{class}} is the base function to show the class of an object
inside the R workspace.

\code{\link{tableHead}} returns the first rows of a database table.

\code{\link{MSSQL-package}} gives an overview of the package.
}
