% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{mst}
\alias{mst}
\title{Multiscalar Typology}
\usage{
mst(x, var1, var2, ref = NULL, key, spdf, order = NULL, dist = NULL,
  mat = NULL, spdfid = NULL, xid = NULL, threshold, superior = FALSE)
}
\arguments{
\item{x}{a dataframe.}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{ref}{ratio of reference; if NULL, the ratio of reference is the one of 
the whole study area (\code{sum(var1) / sum(var2)}).}

\item{key}{aggregation key field.}

\item{spdf}{a SpatialPolygonsDataFrame that matches x data frame.}

\item{order}{contiguity order.}

\item{dist}{distance threshold defining the contiguity. The cartesian 
distance between units centroids is used by default 
(see \code{\link{gDistance}}); use mat to apply different metrics.}

\item{mat}{a distance matrix (road distance, travel time...) between x units. 
Row and column names must fit xid identifiers. (optional)}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{xid}{identifier field in x, default to the first column 
of x. (optional)}

\item{threshold}{defined to build the typology (100 is considered as the average).}

\item{superior}{if TRUE, deviation values must be greater than threshold. If FALSE, 
deviation values must be lower than threshold.}
}
\value{
A dataframe including the initial dataset, the ratio, the 3 relative 
deviations (G, T and S) and the resulting typology. 
\itemize{Typology (which deviation is over/under the threshold):
\item{0: none}
\item{1: G }
\item{2: T}
\item{3: G and T}
\item{4: S}
\item{5: G and S}
\item{6: T and S}
\item{7: G, T and S}
}
}
\description{
This function compute a multiscalar typology according to the three relative 
deviations (general: G, territorial: T and spatial: S). The elementary units are classified
in eight classes according to their three relative positions.
}
\examples{
data("GrandParisMetropole")
synthesis <- mst(spdf = com.spdf,
                        x = com,
                        spdfid = "DEPCOM",
                        xid = "DEPCOM",
                        var1 = "INC",
                        var2 = "TH",
                        dist = NULL,
                        key = "EPT",
                        order = 1,
                        mat = NULL,
                        threshold = 125,
                        superior = TRUE)

if(require('cartography')){
  par(mar = c(0,0,1.2,0))
  typoLayer(spdf = com.spdf, df = synthesis, var = "mst",
            border = "#D9D9D9",legend.values.order = 0:7, 
            col = c("#f0f0f0", "#fdc785","#ffffab","#fba9b0",
                    "#addea6","#ffa100","#fff226","#e30020"),
            lwd = 0.25,
            legend.pos = "n")
  
  plot(ept.spdf,add=TRUE)
  
  colours <- c("#f0f0f0", "#fdc785","#ffffab","#fba9b0",
               "#addea6","#ffa100","#fff226","#e30020")
  
  rVal<-c(" .     .   . ",
          "[X]   .   . ",
          " .   [X]  . ",
          "[X] [X]  . ",
          " .    .   [X]",
          "[X]  .   [X]",
          " .   [X] [X]",
          "[X] [X] [X]")
  
  legendTypo(col = colours, categ = rVal,
             title.txt = "General, territorial and spatial\\ndeviations above 125 \%
             \\n       G T S",
             nodata = FALSE)
  
  layoutLayer(title = "Multiscalar Typology",
              sources = "GEOFLA® 2015 v2.1, Apur, impots.gouv.fr",
              author = "MTA")
}
}
