% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mas.R
\name{mas}
\alias{mas}
\title{Multiscalar Absolute Synthesis}
\usage{
mas(x, xid, var1, var2, ref, key, order, dist, mat)
}
\arguments{
\item{x}{an sf object or a SpatialPolygonsDataFrame including var1 and var2.}

\item{xid}{identifier field in x (to be used for importing a personal distance 
matrix). Default to the first column.}

\item{var1}{name of the numerator variable in x.}

\item{var2}{name of the denominator variable in x.}

\item{ref}{ratio of reference; if missing, the ratio of reference is the one of 
the whole study area (\code{sum(var1) / sum(var2)}).}

\item{key}{aggregation key field for measuring the deviation (intermediate territorial level).}

\item{order}{contiguity order.}

\item{dist}{distance threshold defining the contiguity. The cartesian 
distance between units centroids is used by default 
(see \code{\link{st_distance}}); use mat to apply different metrics.}

\item{mat}{a distance matrix (road distance, travel time...) between x units. 
Row and column names must fit xid identifiers. (optional)}
}
\value{
A dataframe including the mass of numerator to redistribue to reach a perfect equilibrium 
according to the 3 contexts, expressed in numerator measure unit and as a share of the numerator mass.
}
\description{
This function sums the total amount of redistributions according to the three absolute 
deviations (global, territorial, spatial).
}
\examples{
data("GrandParisMetropole")
redistr <- mas(x = com, var1 = "INC", var2 = "TH", dist = 5000, key = "EPT")
redistr
}
