% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.prep.R
\name{data.prep}
\alias{data.prep}
\title{A Function for Preparing mRNAseq and Copy Number Data Matrices}
\usage{
data.prep(exp.mat, cn.mat, gene.annot, sample.annot = NULL, log.exp = FALSE,
  gene.list = NULL)
}
\arguments{
\item{exp.mat}{A matrix of gene-level expression data (rows = genes, columns = samples).
Both row names (gene names) and column names (sample IDs) must be given.}

\item{cn.mat}{A matrix of gene-level DNA copy number data (rows = genes, columns = samples).
DNA methylation data can also be used.  Both row names (gene names) and column names (Sample IDs) must be given.}

\item{gene.annot}{A three-column matrix containing gene position information.  Column 1 = chromosome number written in 
the form 'chr1' (note that chrX and chrY should be written chr23 and chr24), Column 2 = position (in base pairs), Column 3 = cytoband.}

\item{sample.annot}{An optional two-column matrix of sample annotation data.  Column 1 = sample IDs, Column 2 = categorical sample annotation 
(e.g. tumor vs. normal).  If NULL, sample annot will be created using the common sample IDs and a single group ('1').  Default = NULL.}

\item{log.exp}{A logical value indicating whether or not the expression values have been log-transformed.  Default = FALSE.}

\item{gene.list}{Used to restrict the output to a set of genes of interest, e.g. genes identified by GISTIC as having
recurrent copy number alterations.  Default = NULL, and in this case all genes are used.}
}
\value{
Returns a list with four components:  cn, exp, gene.annot, and sample.annot.  Each of cn, exp, and gene.annot have been restricted 
to a common set of genes, and these appear in the same order.  Similarly, cn, exp, and sample.annot have been restricted to a common set
	of subjects that appear in the same order.
}
\description{
This function prepares mRNAseq and copy number data matrices for use in other mVisAGe functions.
}
\examples{
exp.mat = tcga.exp.convert(exp.mat)

 cn.mat = tcga.cn.convert(cn.mat)

 data.prep(exp.mat, cn.mat, gene.annot, sample.annot, log.exp = FALSE)

}
