% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{t.test}
\alias{t.test}
\alias{t.test.ResamplesDiff}
\title{Paired t-Tests for Model Comparisons}
\usage{
\method{t}{test.ResamplesDiff}(x, adjust = "holm", ...)
}
\arguments{
\item{x}{object containing paired differences between resampled metrics.}

\item{adjust}{p-value adjustment for multiple statistical comparisons as
implemented by \code{\link[stats]{p.adjust}}.}

\item{...}{arguments passed to other metrics.}
}
\value{
ResamplesHTest class object that inherits from array.  p-values and
mean differences are contained in the lower and upper triangular portions,
respectively, of the first two dimensions.  Model pairs are contined in the
third dimension.
}
\description{
Paired t-test comparisons of resampled performance metrics from different
models.
}
\examples{
## Numeric response example
library(MASS)

fo <- medv ~ .
control <- CVControl()

gbmperf1 <- resample(fo, Boston, GBMModel(n.trees = 25), control)
gbmperf2 <- resample(fo, Boston, GBMModel(n.trees = 50), control)
gbmperf3 <- resample(fo, Boston, GBMModel(n.trees = 100), control)

perf <- Resamples(GBM1 = gbmperf1, GBM2 = gbmperf2, GBM3 = gbmperf3)
perfdiff <- diff(perf)
t.test(perfdiff)

}
\seealso{
\code{\link{diff}}
}
