% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\alias{performance.Resamples}
\alias{performance.factor}
\alias{performance.matrix}
\alias{performance.numeric}
\alias{performance.Surv}
\alias{modelmetrics}
\title{Model Performance Metrics}
\usage{
performance(x, ...)

\method{performance}{Resamples}(x, ..., na.rm = TRUE)

\method{performance}{factor}(x, y, metrics = c(Accuracy =
  MachineShop::accuracy, Kappa = MachineShop::kappa2, ROCAUC =
  MachineShop::roc_auc, Sensitivity = MachineShop::sensitivity, Specificity
  = MachineShop::specificity, Brier = MachineShop::brier), cutoff = 0.5,
  ...)

\method{performance}{matrix}(x, y, metrics = c(R2 = MachineShop::r2, RMSE
  = MachineShop::rmse, MAE = MachineShop::mae), ...)

\method{performance}{numeric}(x, y, metrics = c(R2 = MachineShop::r2,
  RMSE = MachineShop::rmse, MAE = MachineShop::mae), ...)

\method{performance}{Surv}(x, y, metrics = c(CIndex =
  MachineShop::cindex, ROC = MachineShop::roc_auc, Brier =
  MachineShop::brier), times = numeric(), ...)

modelmetrics(...)
}
\arguments{
\item{x}{observed responses or class containing observed and predicted
responses.}

\item{...}{arguments passed from the \code{Resamples} method to the others
and from deprecated function \code{modelmetrics} to \code{performance}.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{y}{predicted responses.}

\item{metrics}{function, one or more function names, or list of named
functions to include in the calculation of performance metrics.}

\item{cutoff}{threshold above which probabilities are classified as success
for binary responses.}

\item{times}{numeric vector of follow-up times at which survival events
were predicted.}
}
\description{
Compute measures of model performance.
}
\examples{
res <- resample(Species ~ ., data = iris, model = GBMModel)
(perf <- performance(res))
summary(perf)
plot(perf)

## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
gbmfit <- fit(fo, data = Melanoma, model = GBMModel)

obs <- response(fo, data = Melanoma)
pred <- predict(gbmfit, newdata = Melanoma, type = "prob")
performance(obs, pred)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{metrics}}
}
