% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_AdaBagModel.R
\name{AdaBagModel}
\alias{AdaBagModel}
\title{Bagging with Classification Trees}
\usage{
AdaBagModel(mfinal = 100, minsplit = 20,
  minbucket = round(minsplit/3), cp = 0.01, maxcompete = 4,
  maxsurrogate = 5, usesurrogate = 2, xval = 10,
  surrogatestyle = 0, maxdepth = 30)
}
\arguments{
\item{mfinal}{number of trees to use.}

\item{minsplit}{minimum number of observations that must exist in a node in
order for a split to be attempted.}

\item{minbucket}{minimum number of observations in any terminal node.}

\item{cp}{complexity parameter.}

\item{maxcompete}{number of competitor splits retained in the output.}

\item{maxsurrogate}{number of surrogate splits retained in the output.}

\item{usesurrogate}{how to use surrogates in the splitting process.}

\item{xval}{number of cross-validations.}

\item{surrogatestyle}{controls the selection of a best surrogate.}

\item{maxdepth}{maximum depth of any node of the final tree, with the root
node counted as depth 0.}
}
\value{
\code{MLModel} class object.
}
\description{
Fits the Bagging algorithm proposed by Breiman in 1996 using classification
trees as single classifiers.
}
\details{
\describe{
\item{Response Types:}{\code{factor}}
\item{\link[=tune]{Automatic Tuning} Grid Parameters:}{
  \code{mfinal}, \code{maxdepth}
}
}

Further model details can be found in the source link below.
}
\examples{
fit(Species ~ ., data = iris, model = AdaBagModel(mfinal = 5))

}
\seealso{
\code{\link[adabag]{bagging}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
