% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_GLMModel.R
\name{GLMModel}
\alias{GLMModel}
\alias{GLMStepAICModel}
\title{Generalized Linear Model}
\usage{
GLMModel(family = NULL, ...)

GLMStepAICModel(family = NULL, ..., direction = c("both", "backward",
  "forward"), scope = NULL, k = 2, trace = FALSE, steps = 1000)
}
\arguments{
\item{family}{description of the error distribution and link function to be
used in the model.  Set automatically according to the class type of the
response variable.}

\item{...}{arguments passed to \code{\link[stats]{glm.control}}.}

\item{direction}{mode of stepwise search, can be one of \code{"both"}
(default), \code{"backward"}, or \code{"forward"}.}

\item{scope}{defines the range of models examined in the stepwise search.
This should be a list containing components \code{upper} and
\code{lower}, both formulae.}

\item{k}{multiple of the number of degrees of freedom used for the penalty.
Only \code{k = 2} gives the genuine AIC: \code{k = log(nobs)} is sometimes
referred to as BIC or SBC.}

\item{trace}{if positive, information is printed during the running of
\code{stepAIC}. Larger values may give more information on the fitting
process.}

\item{steps}{maximum number of steps to be considered.}
}
\value{
\code{MLModel} class object.
}
\description{
Fits generalized linear models, specified by giving a symbolic description of
the linear predictor and a description of the error distribution.
}
\details{
\describe{
\item{Response Types:}{\code{binary factor}, \code{numeric}}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.
}
\examples{
fit(sale_amount ~ ., data = ICHomes, model = GLMModel())

}
\seealso{
\code{\link[stats]{glm}}, \code{\link[stats]{glm.control}},
\code{\link[MASS]{stepAIC}}, \code{\link{fit}}, \code{\link{resample}},
\code{\link{tune}}
}
