% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_kmedoids.R
\name{step_kmedoids}
\alias{step_kmedoids}
\alias{tidy.step_kmedoids}
\alias{tunable.step_kmedoids}
\title{K-Medoids Clustering Variable Selection}
\usage{
step_kmedoids(
  recipe,
  ...,
  k = 5,
  center = TRUE,
  scale = TRUE,
  metric = c("euclidean", "manhattan"),
  optimize = FALSE,
  replace = TRUE,
  prefix = "KMedoids",
  role = "predictor",
  skip = FALSE,
  id = recipes::rand_id("kmedoids")
)

\method{tidy}{step_kmedoids}(x, ...)

tunable.step_kmedoids(x, ...)
}
\arguments{
\item{recipe}{\link[recipes]{recipe} object to which the step will be added.}

\item{...}{one or more selector functions to choose which variables will be
used to compute the components.  See \code{\link[recipes]{selections}} for
more details.  These are not currently used by the \code{tidy} method.}

\item{k}{number of k-medoids clusterings of the variables.  The value of
\code{k} is constrained to be between 1 and one less than the number of
original variables.}

\item{center, scale}{logicals indicating whether to mean center and median
absolute deviation scale the original variables prior to cluster
partitioning; not applied to selected variables.}

\item{metric}{character string specifying the distance metric for calculating
dissimilarities between observations.}

\item{optimize}{logical indicator or 0:5 integer level specifying
optimization for the clustering algorithm.  See the \code{pamonce} argument
of \code{\link[cluster]{pam}} for details.}

\item{replace}{logical indicating whether to replace the original variables.}

\item{prefix}{if the original variables are not replaced, a character string
prefix added to a sequence of zero-padded integers to generate names for
the resulting new variables; otherwise, the original variable names are
retained.}

\item{role}{analysis role that added step variables should be assigned.  By
default, they are designated as model predictors.}

\item{skip}{logical indicating whether to skip the step when the recipe is
baked.  While all operations are baked when \code{\link[recipes]{prep}} is
run, some operations may not be applicable to new data (e.g. processing
outcome variables).  Care should be taken when using \code{skip = TRUE} as
it may affect the computations for subsequent operations.}

\item{id}{unique character string to identify the step.}

\item{x}{\code{step_kmedoids} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any).  For the \code{tidy} method, a tibble
with columns \code{terms} (selectors or variables selected), \code{cluster}
assignments, \code{medoid} (logical indicator of cluster medoids),
\code{silhouette} (silhouette values), and \code{names} for the new
variables.
}
\description{
Creates a \emph{specification} of a recipe step that will partition numeric
variables according to k-medoids clustering and select the cluster medoids.
}
\details{
K-medoids clustering partitions variables into k groups such that the
dissimilarity between the variables and their assigned cluster medoids is
minimized.  Cluster medoids are then returned as a set of k variables.
}
\examples{
library(recipes)

rec <- recipe(rating ~ ., data = attitude)
kmedoids_rec <- rec \%>\%
  step_kmedoids(all_predictors(), k = 3)
kmedoids_prep <- prep(kmedoids_rec, training = attitude)
kmedoids_data <- bake(kmedoids_prep, attitude)

pairs(kmedoids_data, lower.panel = NULL)

tidy(kmedoids_rec, number = 1)
tidy(kmedoids_prep, number = 1)

}
\references{
Reynolds A, Richards G, de la Iglesia B and Rayward-Smith V (1992).
Clustering rules: a comparison of partitioning and hierarchical clustering
algorithms. Journal of Mathematical Modelling and Algorithms 5, 475--504.
}
\seealso{
\code{\link[cluster]{pam}}, \code{\link[recipes]{recipe}},
\code{\link[recipes]{prep}}, \code{\link[recipes]{bake}}
}
