% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{ParameterGrid}
\alias{ParameterGrid}
\alias{ParameterGrid.param}
\alias{ParameterGrid.list}
\alias{ParameterGrid.parameters}
\title{Tuning Parameters Grid}
\usage{
ParameterGrid(...)

\method{ParameterGrid}{param}(..., size = 3, random = FALSE)

\method{ParameterGrid}{list}(x, size = 3, random = FALSE, ...)

\method{ParameterGrid}{parameters}(x, size = 3, random = FALSE, ...)
}
\arguments{
\item{...}{named \code{param} objects as defined in the \pkg{dials} package.}

\item{size}{single integer or vector of integers whose positions or names
match the given parameters and which specify the number of values used to
construct the grid.}

\item{random}{number of unique points to sample at random from the grid
defined by \code{size}, or \code{FALSE} for all points.}

\item{x}{list of named \code{param} objects or a
\code{\link[dials]{parameters}} object.}
}
\value{
\code{ParameterGrid} class object that inherits from
\code{parameters} and \code{Grid}.
}
\description{
Defines a tuning grid from a set of parameters.
}
\examples{
## GBMModel tuning parameters
grid <- ParameterGrid(
  n.trees = dials::trees(),
  interaction.depth = dials::tree_depth(),
  random = 5
)
TunedModel(GBMModel, grid = grid)

}
\seealso{
\code{\link{TunedModel}}
}
