% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_EarthModel.R
\name{EarthModel}
\alias{EarthModel}
\title{Multivariate Adaptive Regression Splines Model}
\usage{
EarthModel(
  pmethod = c("backward", "none", "exhaustive", "forward", "seqrep", "cv"),
  trace = 0,
  degree = 1,
  nprune = NULL,
  nfold = 0,
  ncross = 1,
  stratify = TRUE
)
}
\arguments{
\item{pmethod}{pruning method.}

\item{trace}{level of execution information to display.}

\item{degree}{maximum degree of interaction.}

\item{nprune}{maximum number of terms (including intercept) in the pruned
model.}

\item{nfold}{number of cross-validation folds.}

\item{ncross}{number of cross-validations if \code{nfold > 1}.}

\item{stratify}{logical indicating whether to stratify cross-validation
samples by the response levels.}
}
\value{
\code{MLModel} class object.
}
\description{
Build a regression model using the techniques in Friedman's papers
"Multivariate Adaptive Regression Splines" and "Fast MARS".
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{nprune}, \code{degree}*
  }
}
* excluded from grids by default

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.

In calls to \code{\link{varimp}} for \code{EarthModel}, argument
\code{type} may be specified as \code{"nsubsets"} (default) for the number of
model subsets that include each predictor, as \code{"gcv"} for the
generalized cross-validation decrease over all subsets that include each
predictor, or as \code{"rss"} for the residual sums of squares decrease.
Variable importance is automatically scaled to range from 0 to 100.  To
obtain unscaled importance values, set \code{scale = FALSE}.  See example
below.
}
\examples{
\donttest{
## Requires prior installation of suggested package earth to run

model_fit <- fit(Species ~ ., data = iris, model = EarthModel)
varimp(model_fit, type = "gcv", scale = FALSE)
}

}
\seealso{
\code{\link[earth]{earth}}, \code{\link{fit}},
\code{\link{resample}}
}
