% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_load.R
\name{table_load}
\alias{table_load}
\title{Load a known location table}
\usage{
table_load(collectionName = NULL)
}
\arguments{
\item{collectionName}{Character identifier for this table, Default: NULL}
}
\value{
Tibble of known locations.
}
\description{
Load a tibble of known locations from the preferred directory.
}
\examples{
library(MazamaLocationUtils)

# Set the directory for saving location tables
setLocationDataDir(tempdir())

# Load an example table and check the dimensions
locationTbl <- get(data("wa_monitors_500"))
dim(locationTbl)

# Save it as "table_load_example"
table_save(locationTbl, "table_load_example")

# Load it and check the dimensions
my_table <- table_load("table_load_example")
dim(my_table)

# Check the locationDataDir
list.files(getLocationDataDir(), pattern = "table_load_example")
}
\seealso{
\code{\link{setLocationDataDir}}
}
