% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_updateSingleRecord.R
\name{table_updateSingleRecord}
\alias{table_updateSingleRecord}
\title{Update a single known location record in a table}
\usage{
table_updateSingleRecord(
  locationTbl = NULL,
  locationList = NULL,
  verbose = TRUE
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{locationList}{List containing \code{locationID} and one or more named
columns whose values are to be replaced.}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Information in the \code{locationList} is used to replace
existing information found in \code{locationTbl}. This function can be used
for small tweaks to an existing \code{locationTbl}. Wholesale replacement of
records should be performed with \code{table_removeRecord()} followed by
\code{table_addLocation()}.
}
\examples{
library(MazamaLocationUtils)

locationTbl <- get(data("wa_monitors_500"))

# Wenatchee
wenatcheeRecord <- 
  locationTbl \%>\% 
  dplyr::filter(city == "Wenatchee")

str(wenatcheeRecord)

wenatcheeID <- wenatcheeRecord$locationID

locationTbl <- table_updateSingleRecord(
  locationTbl,
  locationList = list(
    locationID = wenatcheeID,
    locationName = "Wenatchee-Fifth St"
  )
)

# Look at the new record
locationTbl \%>\% 
  dplyr::filter(city == "Wenatchee") \%>\%
  str()

}
\seealso{
\link{table_addLocation}

\link{table_addSingleLocation}

\link{table_removeRecord}
}
