% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MRInput-class}
\alias{MRInput-class}
\title{MRInput Class}
\description{
An object containing the four vectors of summary statistics required to calculate Mendelian randomization estimates.
}
\details{
The beta-coefficients are assumed to be estimated for uncorrelated (independent) genetic variants, although a correlation matrix can be specified if the variants are correlated in their distributions. We also assume that the beta-coefficients for associations with the exposure and with the outcome are uncorrelated (corresponding to a two-sample Mendelian randomization analysis), although correlation between associations with the exposure and with the outcome generally have little impact on causal estimates or standard errors.
Estimates can either be specified by the user, or extracted from the PhenoScanner tool.
}
\section{Slots}{

\describe{
\item{\code{betaX}}{A numeric vector of beta-coefficient values for genetic associations with the first variable (often referred to as the exposure, risk factor, or modifiable phenotype).}

\item{\code{betaY}}{A numeric vector of beta-coefficient values for genetic associations with the second variable (often referred to as the outcome). For a disease outcome, the beta coefficients are log odds estimates from logistic regression analyses.}

\item{\code{betaXse}}{The standard errors associated with the beta-coefficients in \code{betaX}.}

\item{\code{betaYse}}{The standard errors associated with the beta-coefficients in \code{betaY}.}

\item{\code{correlation}}{The matrix of correlations between genetic variants. If this variable is not provided, then we assume that genetic variants are uncorrelated.}

\item{\code{exposure}}{The name of the exposure variable.}

\item{\code{outcome}}{The name of the outcome variable.}

\item{\code{snps}}{The names of the genetic variants (SNPs) included in the analysis. The slots \code{exposure}, \code{outcome}, and \code{snps} are not required, but may be useful for keeping track of various \code{MRInput} objects. They are also used by the \code{mr_plot} function.}

\item{\code{effect_allele}}{The name of the effect allele for each SNP. The beta-coefficients are the associations with the exposure and outcome per additional copy of the effect allele.}

\item{\code{other_allele}}{The name of the non-effect allele.}

\item{\code{eaf}}{The expected allele frequencies (numeric). The slots \code{effect_allele}, \code{other_allele}, and \code{eaf} are neither required, nor currently used in the MendelianRandomization package. They are included for future compatibility with the MR-Base suite of functions.}
}}
\seealso{
\code{extract.pheno.csv()} for a description of how the above values can be extracted from PhenoScanner \url{http://www.phenoscanner.medschl.cam.ac.uk/}.
}

