% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_log2FC.R
\name{calculate_log2FC}
\alias{calculate_log2FC}
\title{Calculate log2 fold change}
\usage{
calculate_log2FC(
  metalyzer_se,
  categorical,
  impute_perc_of_min = 0.2,
  impute_NA = FALSE
)
}
\arguments{
\item{metalyzer_se}{A Metalyzer object}

\item{categorical}{A column specifying the two groups}

\item{impute_perc_of_min}{A numeric value below 1}

\item{impute_NA}{Logical value whether to impute NA values}
}
\value{
A data frame containing the log2 fold change for each metabolite
}
\description{
This function calculates the log2 fold change of two groups from
plotting_data.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_mutation_data_xl())
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = "Metabolism Indicators"
)
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Mutant_Control = "Sample Description"
)

metalyzer_se <- calculate_log2FC(
  metalyzer_se,
  categorical = "Mutant_Control",
  impute_perc_of_min = 0.2,
  impute_NA = FALSE
)
}
