% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_functions.R
\name{simulate_initialData}
\alias{simulate_initialData}
\title{Simulate Initial Data}
\usage{
simulate_initialData(
  infoStr,
  params = NULL,
  CFTP = FALSE,
  CFTP_step_limit = 327680000
)
}
\arguments{
\item{infoStr}{A data frame containing columns 'n' for the number of sites, and 'globalState' for the favoured global methylation state.
If customized equilibrium frequencies are given, it also contains columns 'u_eqFreq', 'p_eqFreq' and 'm_eqFreq'
with the equilibrium frequency values for unmethylated, partially methylated and methylated.}

\item{params}{Optional data frame with specific parameter values.}

\item{CFTP}{Default FALSE. TRUE for calling cftp algorithm to set root state according to model equilibrium (Note that current implementation neglects IWE process).
Structure as in get_parameterValues() output. If not provided, default values will be used.}

\item{CFTP_step_limit}{when CFTP = TRUE, maximum number of steps before applying an approximation method
(default 327680000 corresponding to size of CFTP info of approx 6.1 GB).}
}
\value{
A list containing the simulated data ($data) and parameters ($params).
}
\description{
This function simulates initial data based on the provided information and parameters.
}
\details{
The function performs several checks on the input data and parameters
to ensure they meet the required criteria and simulates DNA methylation data.
}
\examples{
# Example data
infoStr <- data.frame(n = c(10, 100, 10), globalState = c("M", "U", "M"))

# Simulate initial data  with default parameters
simulate_initialData(infoStr = infoStr)

# Simulate data evolution along a tree with custom parameters
custom_params <- get_parameterValues()
custom_params$iota <- 0.5
simulate_initialData(infoStr = infoStr, params = custom_params)

}
