% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_plot.R
\name{precision_plot}
\alias{precision_plot}
\title{Precision plot used to compare the standard deviation of a new measurement
method with that of a reference standard with possibly heteroscedastic errors}
\usage{
precision_plot(object)
}
\arguments{
\item{object}{an object retunred by a call to \link{measure_compare}}
}
\description{
This plot allows the visual comparison of the precision (i.e. standard deviation)
of the new measurement method with that of a reference standard by creating
a scatter plot of the estimated standard deviation against the best linear
prediction (BLUP) of the latent variable x.
}
\examples{
### load the data
data(data1)
### analysis
measure_model <- measure_compare(data1)
### Precision plot
precision_plot(measure_model)

}
\author{
Mingkai Peng
}

