% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRAnorm.R
\name{miranorm}
\alias{miranorm}
\title{Adaptive algorithm to identify normalization genes.}
\usage{
miranorm(data = dat, group = dat$Trt, max = 15, min = 3,
  method = "complex", dis.method = "Euclidean", hclust.method = "single",
  ct = 25, missing = 0, clustplot = TRUE, selected = 4, ggplot = TRUE,
  heatmap = TRUE, known.positives = NULL, suggested.list = NULL,
  exclude = NULL)
}
\arguments{
\item{data}{Dataframe containing at a minimum:  Sample, Gene, Ct, and Trt}

\item{group}{Treatment allocation.  This should be the same length as the number of rows in data.}

\item{max}{When method is chosen as "complex", this determines the maximum selected size at which the stability evaluation is done.}

\item{min}{When method is chosen as "complex", this determines the minimum selected size at which the stability evaluation is done.}

\item{method}{Choice of "simple" or "complex".
Simple runs a single pass of miranorm for suggested normalizing genes.
Complex runs bootstrap samples across a range of sizes to compute a stability metric.}

\item{dis.method}{Distance metric used to calculate pairwise distance between individual miRNAs across all samples.
Currently "Euclidean" and "1-Cor" are implemented.}

\item{hclust.method}{The agglomeration method used to group genes.
Methods are the same as defined in the hclust function in the stats package and include
"single", "average", "complete", and "ward.D2".
"single" is recommended as it is more robust to small perturbations and tends to form the "chaining" phenomenon useful for defining normalizing genes.}

\item{ct}{Cycle threshold values at or above this level are treated as NA for the purposes of determining normalization genes.  Recommend the value be set to 25.}

\item{missing}{Defines maximum percentage of samples missing for a given gene before that gene is excluded from dataset during normalization.}

\item{clustplot}{"True" or "False" to output or suppress stability plot.  Only applicable if method = "complex".}

\item{selected}{How many adaptive normalizing genes to search for in panel.  Note, actual number of genes found may be larger based on tree cut.}

\item{ggplot}{"True" or "False" to output general raw data plots.}

\item{heatmap}{"True or "False" to output or suppress heatmap plot.}

\item{known.positives}{Names of miRNA that are known positive.  These will be added automatically to the heatmap plot.}

\item{suggested.list}{Names of miRNA that are user suggested normalizing miRNA.  These will be added automatically to the heatmap plot.}

\item{exclude}{List of miRNA to exclude from the selection process for HK genes, eg: known.positives should be included here.}
}
\value{
A list including the following: nmean, nmed, nlcv, lcv.gene, ncls, ncls.gene.

nmean is the dataset normalized to the global mean.

nmed is the dataset normalized to the global median.

nlcv is the dataset normalized to the average of the 3 genes with the lowest CV.

lcv.gene is the names of the 3 genes with used to normalize nlcv

ncls is the dataset normalized to the adaptive normalizing genes chosen from miranorm.

ncls.gene is the names of the genes chosen as adaptive normalizing genes chosen from miranorm.
}
\description{
\code{miranorm} returns a list of suggested normalizaiton genes based on supplied data.  Various output figures are also available
if requested in the parameter list.
}
\examples{
dat = simData(n.trt=15, n.ctrl=15, n.gene=30, n.err=10, sigma.error = c(1, 0.3), mean.sample = 2,
sigma.sample = 1.88 , sigma.gene = 0.1, n.big.effect = 5, n.small.effect = 10, mean.big.effect = 2,
mean.small.effect = 1.2)$sim

obj = miranorm(data = dat, group = dat$Group, method="simple")


}

