% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrinsicIsotopes.R
\name{getIsoMap}
\alias{getIsoMap}
\title{Get Isoscape map
getIsoMap}
\usage{
getIsoMap(
  element = "Hydrogen",
  surface = FALSE,
  period = "Annual",
  mapDirectory = NULL
)
}
\arguments{
\item{element}{The elemental isotope of interest. Currently the only
elements that are implemented are 'Hydrogen' (default) and 'Oxygen'}

\item{surface}{DEPRECATED function no longer returns surface water values.
Default is 'FALSE' which returns the precipitation isotopes ratio.}

\item{period}{The time period of interest. If 'Annual' (default) returns a
raster of mean annual values in precipitation for the \code{element}. If
'GrowingSeason' returns growing season values in precipitation for
 \code{element} of interest.}

\item{mapDirectory}{Directory to save/read isotope map from. Can use relative
or absolute addressing. The default value (NULL) downloads to a temporary
directory, so we strongly recommend changing this from the default unless
you're sure you're not going to need these data more than once.}
}
\value{
returns a global \code{RasterLayer} (resolution = 0.333'x0.3333')
    object for the \code{element} and \code{period} of interest
}
\description{
The \code{getIsoMap} function downloads predicted isoscape maps from
 \url{https://wateriso.utah.edu/waterisotopes/}. The function first checks
whether the isoscapes are located within the directory
\code{mapDirectory}. If a local copy of the isoscape is found, it's read into
the environment. If not, the isoscape is downloaded and imported
as a raster.
}
\examples{
\donttest{
  map <- getIsoMap(element = "Hydrogen", period = "GrowingSeason")
}
}
