% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{plot_guild_pq}
\alias{plot_guild_pq}
\title{Plot information about Guild from tax_table slot previously
created with \code{\link[=add_funguild_info]{add_funguild_info()}}}
\usage{
plot_guild_pq(physeq, levels_order = NULL, clean_pq = TRUE, ...)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{levels_order}{(Default NULL) A character vector to
reorder the levels of guild. See examples.}

\item{clean_pq}{(logical, default TRUE): Does the phyloseq
object is cleaned using the \code{\link[=clean_pq]{clean_pq()}} function?}

\item{...}{other params for be passed on to
\code{\link[=clean_pq]{clean_pq()}} function}
}
\value{
A ggplot2 object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
d_fung_mini <- add_funguild_info(data_fungi_mini,
  taxLevels = c(
    "Domain",
    "Phylum",
    "Class",
    "Order",
    "Family",
    "Genus",
    "Species"
  )
)
sort(table(d_fung_mini@tax_table[, "guild"]), decreasing = TRUE)

p <- plot_guild_pq(d_fung_mini)
if(!requireNamespace("patchwork")) {
  (plot_guild_pq(subset_samples(d_fung_mini, Height == "Low"),
    levels_order = p$data$Guild[order(p$data$nb_seq)]
  ) + theme(legend.position = "none")) +
    (plot_guild_pq(subset_samples(d_fung_mini, Height == "High"),
      levels_order = p$data$Guild[order(p$data$nb_seq)]
    ) + ylab("") + theme(axis.text.y = element_blank()))
}
}
}
\seealso{
\code{\link[=add_funguild_info]{add_funguild_info()}}
}
\author{
Adrien Taudière
}
