% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterAlgo.R
\name{clusterAlgo}
\alias{clusterAlgo}
\title{Create an instance of the [\code{\linkS4class{ClusterAlgo}}] class}
\usage{
clusterAlgo(algo = "EM", nbIteration = 200, epsilon = 1e-08)
}
\arguments{
\item{algo}{character string with the estimation algorithm.
Possible values are "EM", "SEM", "CEM", "SemiSEM". Default value is "EM".}

\item{nbIteration}{Integer defining the maximal number of iterations. Default value is 200.}

\item{epsilon}{Real defining the epsilon value for the algorithm. Note that
epsilon is not used by the SEM algorithm. Default value is 1.e-8.}
}
\value{
a [\code{\linkS4class{ClusterAlgo}}] object
}
\description{
There is three algorithms and two stopping rules possibles for an algorithm.
\itemize{
       \item Algorithms:
          \itemize{
              \item \code{EM}  {The Expectation Maximisation algorithm.}
              \item \code{CEM} {The Classification EM algorithm.}
              \item \code{SEM} {The Stochastic EM algorithm.}
              \item \code{SemiSEM} {The Semi-Stochastic EM algorithm.}
          }
       \item Stopping rules:
          \itemize{
              \item \code{nbIteration} {Set the maximum number of iterations.}
              \item \code{epsilon} {Set relative increase of the log-likelihood criterion.}
          }
       \item Default values are \eqn{200} \code{nbIteration} of \code{EM}
        with an \code{epsilon} value of \eqn{1.e-8}.
}
}
\examples{
clusterAlgo()
clusterAlgo(algo="SEM", nbIteration=50)
clusterAlgo(algo="CEM", epsilon = 1e-06)
}
\author{
Serge Iovleff, with contributions from V. Kubicki
}

