% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Learners.R
\name{learnMixedData}
\alias{learnMixedData}
\title{This function learn the optimal mixture model when the class labels are known
according to the \code{criterion} among the list of model given in \code{models}.}
\usage{
learnMixedData(
  data,
  models,
  labels,
  prop = NULL,
  algo = "impute",
  nbIter = 100,
  epsilon = 1e-08,
  criterion = "ICL",
  nbCore = 1
)
}
\arguments{
\item{data}{[\code{list}] containing the data sets (matrices and/or data.frames).
If data sets contain NA values, these missing values will be estimated during
the estimation process.}

\item{models}{either a [\code{vector}] of character or a [\code{list}] of
same length than data. If \code{models} is a vector, it contains the model
names to use in order to fit each data set. If \code{models} is a list, it
must be of the form 
\code{models = list( modelName, dim, kernelName, modelParameters) }
Only modelName is required.}

\item{labels}{vector or factors giving the label class.}

\item{prop}{[\code{\link{vector}}] with the proportions of each class.
If NULL the proportions will be estimated using the labels.}

\item{algo}{character defining the algo to used in order to learn the model.
Possible values: "simul" (default), "impute" (faster but can produce biased results).}

\item{nbIter}{integer giving the number of iterations to do.
algo is "impute" this is the maximal authorized number of iterations. Default is 100.}

\item{epsilon}{real giving the variation of the log-likelihood for stopping the
iterations. Not used if algo is "simul". Default value is 1e-08.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processors to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterMixedDataModel}}] class.
}
\description{
This function learn the optimal mixture model when the class labels are known
according to the \code{criterion} among the list of model given in \code{models}.
}
\examples{
## A quantitative example with the heart disease data set
data(HeartDisease.cat)
data(HeartDisease.cont)
## with default values
ldata = list(HeartDisease.cat, HeartDisease.cont);
models = c("categorical_pk_pjk","gaussian_pk_sjk")
model <- clusterMixedData(ldata, models, nbCluster=2:5, strategy = clusterFastStrategy())

## get summary
summary(model)

## get estimated missing values
missingValues(model)

\dontrun{
## print model
print(model)
## use graphics functions
plot(model)
}

}
\author{
Serge Iovleff
}
