% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_JAGS_model.R
\name{write_JAGS_model}
\alias{write_JAGS_model}
\title{Write the JAGS model file}
\usage{
write_JAGS_model(filename = "MixSIAR_model.txt", resid_err = TRUE,
  process_err = TRUE, mix, source)
}
\arguments{
\item{filename}{the JAGS model file is saved in the working directory as 'filename'
(default is "MixSIAR_model.txt", but user can specify).}

\item{resid_err}{T/F: include residual error in the model?}

\item{process_err}{T/F: include process error in the model?}

\item{mix}{output from \code{\link{load_mix_data}}}

\item{source}{output from \code{\link{load_source_data}}}
}
\description{
\code{write_JAGS_model} creates "MixSIAR_model.txt", which is passed to JAGS
by \code{\link{run_model}} when the "RUN MODEL" button is clicked in the GUI.
Several model options will have already been specified when loading the mix
and source data, but here is where the error term options are selected:
\enumerate{
  \item Residual * Process (resid_err = TRUE, process_err = TRUE)
  \item Residual only (resid_err = TRUE, process_err = FALSE)
  \item Process only (resid_err = FALSE, process_err = TRUE)
}
}
\details{
WARNING messages are displayed if:
\itemize{
 \item resid_err = FALSE and process_err = FALSE are both selected.
 \item N=1 mix data point and did not choose "Process only" error model (MixSIR)
 \item Fitting each individual mix data point separately as a Fixed Effect,
   but did not choose "Process only" error model (MixSIR).
}
}
