% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogconc.R
\name{EMnormal}
\alias{EMnormal}
\title{Parameter Estimation of Normal Mixture Using EM Algorithm}
\usage{
EMnormal(x, C = 2, nstart = 20, tol = 1e-05)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and
p is the dimension of the data.}

\item{C}{number of mixture components. Default is 2.}

\item{nstart}{number of initializations to try. Default is 20.}

\item{tol}{stopping criteria (threshold value) for the EM algorithm. Default is 1e-05.}
}
\value{
A list containing the following elements:
\item{loglik}{final log-likelihood.}
\item{pi}{estimated mixing proportions.}
\item{mu}{estimated component means.}
\item{sigma}{estimated component standard deviation or covariance matrix.}
}
\description{
`EMnormal' is used to estimate the parameters of a univariate or multivariate
normal mixture model using the expectation-maximization (EM) algorithm.
The result can be used as the initial value for the \code{\link{mixLogconc}} and
\code{\link{mixLogconcHD}} function.
}
\examples{
#-----------------------------------------------------------------------------------------#
# Univariate Case
#-----------------------------------------------------------------------------------------#
x = matrix(rnorm(100, 2, sqrt(2)), nrow = 100)
x[1:60] = x[1:60] + 5
ini = EMnormal(x)
}
\seealso{
\code{\link{mixLogconc}}, \code{\link{mixLogconcHD}}
}
