% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixreg.R
\name{mixregBisq}
\alias{mixregBisq}
\title{Robust EM Algorithm For Mixture of Linear Regression Based on Bisquare Function}
\usage{
mixregBisq(x, y, C = 2, nstart = 20)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and p is the number of explanatory variables.
The intercept term will automatically be added to the data.}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{nstart}{number of initializations to try. Default is 20.}
}
\value{
A list containing the following element:
\item{pi}{C-dimensional vector of estimated mixing proportions.}
\item{beta}{C by (p + 1) matrix of estimated regression coefficients.}
\item{sigma}{C-dimensional vector of estimated standard deviations.}
}
\description{
`mixregBisq' is used to robustly estimate the parameters of a mixture regression model
using the bisquare function based on multiple initial values (Bai et al., 2012). The solution is the mode
of the solutions obtained from all initial values.
}
\examples{
data(tone)
y = tone$tuned
x = tone$stretchratio
k = 160
x[151:k] = 0
y[151:k] = 5
est_bi = mixregBisq(x, y, 2, nstart = 20)
}
\references{
Bai, X., Yao, W., and Boyer, J. E. (2012). Robust fitting of mixture regression models.
Computational Statistics & Data Analysis, 56(7), 2347-2359.
}
