% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependogram.R
\name{Dependogram}
\alias{Dependogram}
\title{Dependogram for Cramer-von Mises statistics}
\usage{
Dependogram(out, stat = "CVM")
}
\arguments{
\item{out}{List of the output from EstDep, TestIndCopula or TestIndSerCopula (P-values, subsets)}

\item{stat}{Name of statistics to be used (default is "CVM")}
}
\description{
This function, used in EstDep, TestIndCopula and TestIndSerCopula, draws the P-values of the Moebius Cramer-von Mises statistics from the multilinear copula and their combination for a tests of randomness for k consectives values X(1), ..., X(k) or for a test of independence between random variables.
}
\examples{
x <- matrix(rnorm(250),ncol=5)
out <-TestIndCopula(x)
Dependogram(out)

}
\references{
Genest, Neslehova, Remillard & Murphy (2019). Testing for independence in arbitrary distributions
}
