% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorKnowledge.R
\name{rnormMultiv}
\alias{rnormMultiv}
\title{Multivariate Normal Sample}
\usage{
rnormMultiv(n, dataParents, dataChild)
}
\arguments{
\item{n}{A \code{"numeric"} value which is the size of the prior data to generate.}

\item{dataParents}{A data set of class \code{"data.frame"} giving the data of the set of coditional parent variables.}

\item{dataChild}{A \code{"numeric"} vector containing the original data of the child variable.}
}
\value{
A \code{"numeric"} vector giving the prior data values.
}
\description{
Generate a multivariate normal data vector taking into account the real data and the 
relationships with other variables in the dataset.
}
\examples{

## Data
data(ecoli)
data <- ecoli[,-c(1,9)] ## remove sequece.name and class

## DAG
dag <- LearningHC(data)
plot(dag)
getChildParentsFromGraph(dag)

## 1. Random sample
parents <- "mcg"
child <- "alm1"
n <- 1000
rnormMultiv(n, dataParents = data.frame(data[,parents]), dataChild = data[,child])

## 2. Random sample
parents <- "alm1"
child <- "aac"
n <- 256
rnormMultiv(n, dataParents = data.frame(data[,parents]), dataChild = data[,child])

}
\seealso{
\link{generateNormalPriorData}
}
