% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dataMining}
\alias{dataMining}
\alias{whichDiscrete}
\alias{discreteVariables_as.character}
\alias{standardizeDataset}
\alias{discretizeVariablesEWdis}
\alias{discreteVariablesStates}
\alias{nstates}
\alias{quantileIntervals}
\alias{scaleData}
\title{Data pre-processing utilities}
\usage{
whichDiscrete(dataset, discreteVariables)

discreteVariables_as.character(dataset, discreteVariables)

standardizeDataset(dataset)

discretizeVariablesEWdis(dataset, numIntervals, factor = FALSE, binary = FALSE)

discreteVariablesStates(namevariables, discreteData)

nstates(DiscreteVariablesStates)

quantileIntervals(X, numIntervals)

scaleData(dataset, scale)
}
\arguments{
\item{dataset}{A dataset of class \code{"data.frame"}. Tha variables of the dataset can be discrete and continuous.}

\item{discreteVariables}{A \code{"character"} array with the names of the discrete variables.}

\item{numIntervals}{Number of bins used to discretize the continuous variables.}

\item{factor}{A boolean value indicating if the variables should be considered as
\code{"factor"} or as \code{"character"}. By default it is set to \code{FALSE}.}

\item{binary}{By default it is set to \code{FALSE}, indicating that only binary entries are 
used for continuous variables; a \code{TRUE} value means that binary entries are used to 
discretize the full dataset taking into account the states the discrete variables.}

\item{namevariables}{an array with the names of the varibles.}

\item{discreteData}{A discretized dataset of class \code{"data.frame"}.}

\item{DiscreteVariablesStates}{The output of the function \code{discreteVariablesStates}.}

\item{X}{A \code{"numeric"} vector with the data values of a continuous variable.}

\item{scale}{A \code{"numeric"} vector (when it refers to a single variable) or a \code{"list"} 
containing the name(s) of the variable(s) and the scale value.}
}
\description{
Collection of functions for discretizing, standardizing, converting factors to 
characters and other usufull methods for pre-processing datasets.
}
\details{
\code{whichDiscrete()} selects the position of the discrete variables.

\code{discreteVariables_as.character()} transforms the values of the discrete variables into character values.

\code{standardizeDataset()} standardizes all the variables in a data set.

\code{discretizeVariablesEWdis()} discretizes the continuous variables in a dataset using 
equal width binning.

\code{discreteVariablesStates()} extracts the states of the qualitative variables.

\code{nstates()} computes the number of different values of the discrete variables.

\code{quantileIntervals()} gets the quantiles of a variable taking into account the number of intervals
into which its domain is splitted.
}
\examples{
## dataset: 2 continuous variables, 1 discrete variable.
data <- data.frame(X = rnorm(100),Y = rexp(100,1/2), Z = as.factor(rep(c("s","a"), 50)))
disVar <- "Z" ## Discrete variable
class(data[,disVar]) ## factor

data <- discreteVariables_as.character(dataset = data, discreteVariables = disVar)
class(data[,disVar]) ## character

whichDiscrete(dataset = data, discreteVariables = "Z")

standData <- standardizeDataset(dataset = data)

disData <- discretizeVariablesEWdis(dataset = data, numIntervals = 3)

l <- discreteVariablesStates(namevariables = names(data), discreteData = disData)

nstates(DiscreteVariablesStates = l)

## Continuous variables
quantileIntervals(X = data[,1], numIntervals = 4)
quantileIntervals(X = data[,2], numIntervals = 10)
}
