% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMortalityTables.R
\name{plotMortalityTables}
\alias{plotMortalityTables}
\title{Plot multiple mortality tables (life tables) in one plot}
\usage{
plotMortalityTables(data, ..., ages = NULL, legend.title = "Sterbetafel",
  xlim = NULL, ylim = NULL, xlab = NULL, ylab = NULL, title = "",
  legend.position = c(0.9, 0.1), legend.justification = c(1, 0),
  legend.key.width = unit(25, "mm"))
}
\arguments{
\item{data}{First life table to be plotted. Either a \code{data.frame} generated by \code{makeQxDataFrame} or a \code{mortalityTable} object}

\item{...}{Additional life tables to be plotted (if \code{data} is a \code{mortalityTable} object)}

\item{ages}{Plot only the given ages}

\item{legend.title}{Title of the legend}

\item{xlim}{X-axis limitatation (as a two-element vector)}

\item{ylim}{Y-axis limitatation (as a two-element vector)}

\item{xlab}{X-axis label (default: "Alter")}

\item{ylab}{Y-axis label (default: "Sterbewahrscheinlichkeit q_x relativ zu ....")}

\item{title}{The plot title}

\item{legend.position}{The position of the legend (default is \code{c(0.9,0.1)})}

\item{legend.justification}{The justification of the legend (default is \code{c(1,)})}

\item{legend.key.width}{The keywith of the lines in the  legend (default is \code{unit(25,"mm")})}
}
\description{
\code{plotMortalityTables} prints multiple life tables (objects of child classes of \code{mortalityTable}) in one log-linear plot, with a legend showing the names of the tables.
}
\examples{
# Load the Austrian census data
mortalityTables.load("Austria_Annuities")
mortalityTables.load("Austria_Census")

# Plot some select census tables in a log-linear plot (plot called
# with mortalityTable objects is equla to calling plotMortalitytTables directly)
plot(mort.AT.census.1869.male, mort.AT.census.1869.female,
     mort.AT.census.1971.male, mort.AT.census.1971.female,
     mort.AT.census.2011.male, mort.AT.census.2011.female,
     title="Austrian census tables",
     ylab=expression(q[x]), xlab="Age",
     xlim=c(0,90),
     legend.position=c(0.95,0.05))

# To compare period or cohort life tables, use the YOB and Period arguments:
plot(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
    Period = 2018, title = "Austrian Annuity Tables, Period 2018")
plot(AVOe2005R.male, AVOe2005R.female, AVOe1996R.male, AVOe1996R.female,
    YOB = 2000, title = "Austrian Annuity Tables for cohort YOB=2000")

}
