% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTable.improvementFactors.R
\name{calculateImprovements}
\alias{calculateImprovements}
\alias{calculateImprovements,mortalityTable.improvementFactors-method}
\title{Calculate the improvement factors for the given birth-year and the
\code{\linkS4class{mortalityTable.improvementFactors}} object}
\usage{
calculateImprovements(object, ...)

\S4method{calculateImprovements}{mortalityTable.improvementFactors}(object, ..., Period = NULL, YOB = 1982)
}
\arguments{
\item{object}{A pension table object (instance of a \code{\linkS4class{mortalityTable.improvementFactors}} class)}

\item{...}{Currently unused}

\item{Period}{Observation period (either \code{Period} or \code{YOB} should be given)}

\item{YOB}{Year of birth (either \code{Period} or \code{YOB} should be given)}
}
\description{
Calculate the improvement factors for the given birth-year and the
\code{\linkS4class{mortalityTable.improvementFactors}} object
}
\section{Methods (by class)}{
\itemize{
\item \code{calculateImprovements(mortalityTable.improvementFactors)}: Calculate the total mortality improvement
factors relative to the base year for the given birth-year and the
\code{\linkS4class{mortalityTable.improvementFactors}} object

}}
\examples{
pensionTables.load("USA_PensionPlan_RP2014")
calculateImprovements(RP2014.male@qx, YOB = 2017)

}
