% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiFit.R
\name{uvApproxNull}
\alias{uvApproxNull}
\title{Approximate univariate null distribution}
\usage{
uvApproxNull(uv.null.sim, num.wins, top.max.ps = 4L, verbose = FALSE)
}
\arguments{
\item{uv.null.sim}{Positive integer, the number of simulated values to be computed
in a univariate case when an exact or approximate null distribution is simulated.}

\item{num.wins}{Positive integer, the number of windows that are tested in each
simulation.}

\item{top.max.ps}{Positive integer, report the mean of the top \code{top.max.ps}
order statistics of the negative logarithm of all \code{p}-values.}

\item{verbose}{Logical.}
}
\value{
List of two numerical vectors for each of the global test statistics. Each
such vector is of length \code{uv.null.sim}.
}
\description{
In a univariate case, simulate an approximate null distribution for the global
test statistics.
}
