% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MultiTree}
\alias{MultiTree}
\title{Plot tree structure of tests on 2x2 contingency tables}
\usage{
MultiTree(xy, x = NULL, y = NULL, fit, show.all = FALSE,
  max.node.size = 5, min.node.size = 2.5, use.pval = NULL,
  images.path = NULL, node.name = "node", filename = NULL,
  filetype = "pdf")
}
\arguments{
\item{xy}{A list (optional), whose first element corresponds to the matrix x as below, and
its second element corresponds to the matrix y as below.
if \code{xy} is not specified, \code{x} and \code{y} need to be assigned. If \code{xy},
\code{x} and \code{y} are missing or \code{NULL}, the tree nodes are blank. If
\code{xy} or \code{x} and \code{y} are provided, nodes are \code{png} images of the marginal
scatter plots that are associated with each test.}

\item{x}{A matrix (optional), number of columns = dimension of random vector,
number of rows = number of observations. If \code{xy},
\code{x} and \code{y} are missing or \code{NULL}, the tree nodes are blank. If
\code{xy} or \code{x} and \code{y} are provided, nodes are \code{png} images of the marginal
scatter plots that are associated with each test.}

\item{y}{A matrix (optional), number of columns = dimension of random vector,
number of rows = number of observations. If \code{xy},
\code{x} and \code{y} are missing or \code{NULL}, the tree nodes are blank. If
\code{xy} or \code{x} and \code{y} are provided, nodes are \code{png} images of the marginal
scatter plots that are associated with each test.}

\item{fit}{An object generated by \code{multiFit}.}

\item{show.all}{Logical. If \code{TRUE}, all tests are shown. If \code{FALSE}
only tests who were ranked in each resolution amongst the top \code{M} ranking tests
are shown. See \code{?multiFit} for an explanation about the parameter \code{M} and see
documentation for further information.}

\item{max.node.size}{Numeric. Maximal node size. All nodes are scaled between \code{min.node.size} and
\code{max.node.size}, where larger nodes are associated smaller \code{p}-values of the corresponding tests
on 2x2 contingency tables.}

\item{min.node.size}{Numeric. Minimal node size. All nodes are scaled between \code{min.node.size} and
\code{max.node.size}, where larger nodes are associated smaller \code{p}-values of the corresponding tests
on 2x2 contingency tables.}

\item{use.pval}{String, choose between \code{"H"} (for Holm), \code{"Hcorrected"}
(for Holm on corrected \code{p}-values) or \code{"MH"} for modified Holm.
If left \code{NULL}, the order of preference is \code{"MH"}, \code{"Hcorrected"} and
then \code{"H"}, according to which is present in the object \code{fit}.}

\item{images.path}{String, path to save \code{png} images of nodes to. If not
specified, images are saved to \code{tempdir()}.}

\item{node.name}{String, prefix for file names for nodes \code{png}s.}

\item{filename}{String, file name for tree output. If left \code{NULL}, file name
is prefixed by \code{multiTree} and ends with system time. See documentation of
\code{qgraph::qgraph} for further information.}

\item{filetype}{String, default is \code{pdf}, See documentation of
\code{qgraph::qgraph} for further information.}
}
\value{
The main output of multiTree is a \code{pdf} file with the directed acyclic graph
showing tests as nodes.

In addition, the function returns a list. Its elements are:
\code{qgraph.object}, the graphical object generated by the \code{qgraph} function. See
the \code{qgraph} package documentation for further details.
\code{qgraph.call}, the call for the tree generating function. Arguments for
the call: \code{adj}, the adjacency matrix, \code{nodes.size}, a numeric vector with the
scaled sizes of the nodes, \code{images}, the file names of the nodes images (may be
\code{NULL}), \code{filename} as passed to \code{multiTree} and passed over to \code{qgraph},
and \code{filetype} as passed to \code{multiTree} and passed over to \code{qgraph}.

Other elements of the returned list are \code{pvs.attributes}, the attributes summarizing the
data and the tests performed as stored in \code{fit}, and \code{n.nodes}, the number of nodes.
}
\description{
Plot a post-hoc tree of all tests or all significant tests on 2x2 discretized
contingency tables. See vignettes for examples.
}
