/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.common.RandomUtils;

public final class SamplingLongPrimitiveIterator
extends AbstractLongPrimitiveIterator {
    private final Random random = RandomUtils.getRandom();
    private final LongPrimitiveIterator delegate;
    private final double samplingRate;
    private long next;
    private boolean hasNext;

    public SamplingLongPrimitiveIterator(LongPrimitiveIterator delegate, double samplingRate) {
        this.delegate = delegate;
        this.samplingRate = samplingRate;
        this.hasNext = true;
        this.doNext();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public long nextLong() {
        if (this.hasNext) {
            long result = this.next;
            this.doNext();
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public long peek() {
        if (this.hasNext) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    private void doNext() {
        int toSkip = 0;
        while (this.random.nextDouble() >= this.samplingRate) {
            ++toSkip;
        }
        if (toSkip > 0) {
            this.delegate.skip(toSkip);
        }
        if (this.delegate.hasNext()) {
            this.next = (Long)this.delegate.next();
        } else {
            this.hasNext = false;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skip(int n) {
        this.delegate.skip((int)((double)n / this.samplingRate));
        if (this.delegate.hasNext()) {
            this.next = (Long)this.delegate.next();
        } else {
            this.hasNext = false;
        }
    }

    public static LongPrimitiveIterator maybeWrapIterator(LongPrimitiveIterator delegate, double samplingRate) {
        return samplingRate >= 1.0 ? delegate : new SamplingLongPrimitiveIterator(delegate, samplingRate);
    }
}

