/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MutableRecommendedItem;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.math.SimpleVectorMath;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

final class MostSimilarItemIterator
implements Iterator<RecommendedItem> {
    private final MutableRecommendedItem delegate = new MutableRecommendedItem();
    private final float[][] itemFeatures;
    private final double[] itemFeatureNorms;
    private final Iterator<FastByIDMap.MapEntry<float[]>> Yiterator;
    private final FastIDSet userTagIDs;
    private final long[] toItemIDs;
    private final Rescorer<LongPair> rescorer;

    MostSimilarItemIterator(Iterator<FastByIDMap.MapEntry<float[]>> Yiterator, FastIDSet userTagIDs, long[] toItemIDs, float[][] itemFeatures, Rescorer<LongPair> rescorer) {
        this.toItemIDs = toItemIDs;
        this.itemFeatures = itemFeatures;
        this.Yiterator = Yiterator;
        this.userTagIDs = userTagIDs;
        this.rescorer = rescorer;
        this.itemFeatureNorms = new double[itemFeatures.length];
        for (int i = 0; i < itemFeatures.length; ++i) {
            this.itemFeatureNorms[i] = SimpleVectorMath.norm(itemFeatures[i]);
        }
    }

    @Override
    public boolean hasNext() {
        return this.Yiterator.hasNext();
    }

    @Override
    public RecommendedItem next() {
        FastByIDMap.MapEntry<float[]> entry = this.Yiterator.next();
        long itemID = entry.getKey();
        if (this.userTagIDs.contains(itemID)) {
            return null;
        }
        for (long l : this.toItemIDs) {
            if (l != itemID) continue;
            return null;
        }
        Rescorer<LongPair> rescorer1 = this.rescorer;
        float[] candidateFeatures = entry.getValue();
        double candidateFeaturesNorm = SimpleVectorMath.norm(candidateFeatures);
        double total = 0.0;
        int length = this.itemFeatures.length;
        for (int i = 0; i < length; ++i) {
            long toItemID = this.toItemIDs[i];
            LongPair cachedPair = null;
            if (rescorer1 != null && rescorer1.isFiltered(cachedPair = new LongPair(itemID, toItemID))) {
                return null;
            }
            double similarity = SimpleVectorMath.dot(candidateFeatures, this.itemFeatures[i]) / (candidateFeaturesNorm * this.itemFeatureNorms[i]);
            if (!LangUtils.isFinite(similarity)) {
                return null;
            }
            if (rescorer1 != null && !LangUtils.isFinite(similarity = rescorer1.rescore(cachedPair, similarity))) {
                return null;
            }
            total += similarity;
        }
        float result = (float)(total / (double)length);
        Preconditions.checkState(LangUtils.isFinite(result), "Bad similarity value");
        this.delegate.set(itemID, result);
        return this.delegate;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

