/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import net.myrrix.online.eval.EvaluationResult;
import net.myrrix.online.eval.MyrrixIRStatistics;

final class IRStatisticsImpl
implements MyrrixIRStatistics,
EvaluationResult,
Serializable {
    private final double precision;
    private final double recall;
    private final double nDCG;
    private final double meanAveragePrecision;

    IRStatisticsImpl(double precision, double recall, double nDCG, double meanAveragePrecision) {
        Preconditions.checkArgument(precision >= 0.0 && precision <= 1.0, "Illegal precision: %s", precision);
        Preconditions.checkArgument(recall >= 0.0 && recall <= 1.0, "Illegal recall: %s", recall);
        Preconditions.checkArgument(nDCG >= 0.0 && nDCG <= 1.0, "Illegal nDCG: %s", nDCG);
        Preconditions.checkArgument(meanAveragePrecision >= 0.0 && meanAveragePrecision <= 1.0, "Illegal meanAveragePrecision: %s", meanAveragePrecision);
        this.precision = precision;
        this.recall = recall;
        this.nDCG = nDCG;
        this.meanAveragePrecision = meanAveragePrecision;
    }

    @Override
    public double getScore() {
        return this.getMeanAveragePrecision();
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public double getRecall() {
        return this.recall;
    }

    @Override
    public double getFallOut() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getF1Measure() {
        return this.getFNMeasure(1.0);
    }

    @Override
    public double getFNMeasure(double b) {
        double b2 = b * b;
        double sum = b2 * this.precision + this.recall;
        return sum == 0.0 ? Double.NaN : (1.0 + b2) * this.precision * this.recall / sum;
    }

    @Override
    public double getNormalizedDiscountedCumulativeGain() {
        return this.nDCG;
    }

    @Override
    public double getMeanAveragePrecision() {
        return this.meanAveragePrecision;
    }

    @Override
    public double getReach() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Precision: " + this.precision + "; Recall: " + this.recall + "; nDCG: " + this.nDCG + "; MAP: " + this.meanAveragePrecision;
    }
}

