/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveArrayIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.AbstractDataModel;
import org.apache.mahout.cf.taste.impl.model.BooleanItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.BooleanUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;

public final class GenericBooleanPrefDataModel
extends AbstractDataModel {
    private final long[] userIDs;
    private final FastByIDMap<FastIDSet> preferenceFromUsers;
    private final long[] itemIDs;
    private final FastByIDMap<FastIDSet> preferenceForItems;
    private final FastByIDMap<FastByIDMap<Long>> timestamps;

    public GenericBooleanPrefDataModel(FastByIDMap<FastIDSet> userData) {
        this(userData, null);
    }

    public GenericBooleanPrefDataModel(FastByIDMap<FastIDSet> userData, FastByIDMap<FastByIDMap<Long>> timestamps) {
        Preconditions.checkArgument(userData != null, "userData is null");
        this.preferenceFromUsers = userData;
        this.preferenceForItems = new FastByIDMap();
        FastIDSet itemIDSet = new FastIDSet();
        for (Map.Entry<Long, FastIDSet> entry : this.preferenceFromUsers.entrySet()) {
            long userID = entry.getKey();
            FastIDSet itemIDs = entry.getValue();
            itemIDSet.addAll(itemIDs);
            LongPrimitiveIterator it = itemIDs.iterator();
            while (it.hasNext()) {
                long itemID = it.nextLong();
                FastIDSet userIDs = this.preferenceForItems.get(itemID);
                if (userIDs == null) {
                    userIDs = new FastIDSet(2);
                    this.preferenceForItems.put(itemID, userIDs);
                }
                userIDs.add(userID);
            }
        }
        this.itemIDs = itemIDSet.toArray();
        itemIDSet = null;
        Arrays.sort(this.itemIDs);
        this.userIDs = new long[userData.size()];
        int i = 0;
        LongPrimitiveIterator it = userData.keySetIterator();
        while (it.hasNext()) {
            this.userIDs[i++] = (Long)it.next();
        }
        Arrays.sort(this.userIDs);
        this.timestamps = timestamps;
    }

    @Deprecated
    public GenericBooleanPrefDataModel(DataModel dataModel) throws TasteException {
        this(GenericBooleanPrefDataModel.toDataMap(dataModel));
    }

    public static FastByIDMap<FastIDSet> toDataMap(DataModel dataModel) throws TasteException {
        FastByIDMap<FastIDSet> data = new FastByIDMap<FastIDSet>(dataModel.getNumUsers());
        LongPrimitiveIterator it = dataModel.getUserIDs();
        while (it.hasNext()) {
            long userID = it.nextLong();
            data.put(userID, dataModel.getItemIDsFromUser(userID));
        }
        return data;
    }

    public static FastByIDMap<FastIDSet> toDataMap(FastByIDMap<PreferenceArray> data) {
        for (Map.Entry<Long, PreferenceArray> entry : data.entrySet()) {
            PreferenceArray prefArray = entry.getValue();
            int size = prefArray.length();
            FastIDSet itemIDs = new FastIDSet(size);
            for (int i = 0; i < size; ++i) {
                itemIDs.add(prefArray.getItemID(i));
            }
            entry.setValue((PreferenceArray)((Object)itemIDs));
        }
        return data;
    }

    public FastByIDMap<FastIDSet> getRawUserData() {
        return this.preferenceFromUsers;
    }

    public FastByIDMap<FastIDSet> getRawItemData() {
        return this.preferenceForItems;
    }

    @Override
    public LongPrimitiveArrayIterator getUserIDs() {
        return new LongPrimitiveArrayIterator(this.userIDs);
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws NoSuchUserException {
        FastIDSet itemIDs = this.preferenceFromUsers.get(userID);
        if (itemIDs == null) {
            throw new NoSuchUserException(userID);
        }
        BooleanUserPreferenceArray prefArray = new BooleanUserPreferenceArray(itemIDs.size());
        int i = 0;
        LongPrimitiveIterator it = itemIDs.iterator();
        while (it.hasNext()) {
            prefArray.setUserID(i, userID);
            prefArray.setItemID(i, it.nextLong());
            ++i;
        }
        return prefArray;
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        FastIDSet itemIDs = this.preferenceFromUsers.get(userID);
        if (itemIDs == null) {
            throw new NoSuchUserException(userID);
        }
        return itemIDs;
    }

    @Override
    public LongPrimitiveArrayIterator getItemIDs() {
        return new LongPrimitiveArrayIterator(this.itemIDs);
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws NoSuchItemException {
        FastIDSet userIDs = this.preferenceForItems.get(itemID);
        if (userIDs == null) {
            throw new NoSuchItemException(itemID);
        }
        BooleanItemPreferenceArray prefArray = new BooleanItemPreferenceArray(userIDs.size());
        int i = 0;
        LongPrimitiveIterator it = userIDs.iterator();
        while (it.hasNext()) {
            prefArray.setUserID(i, it.nextLong());
            prefArray.setItemID(i, itemID);
            ++i;
        }
        return prefArray;
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws NoSuchUserException {
        FastIDSet itemIDs = this.preferenceFromUsers.get(userID);
        if (itemIDs == null) {
            throw new NoSuchUserException(userID);
        }
        if (itemIDs.contains(itemID)) {
            return Float.valueOf(1.0f);
        }
        return null;
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        if (this.timestamps == null) {
            return null;
        }
        FastByIDMap<Long> itemTimestamps = this.timestamps.get(userID);
        if (itemTimestamps == null) {
            throw new NoSuchUserException(userID);
        }
        return itemTimestamps.get(itemID);
    }

    @Override
    public int getNumItems() {
        return this.itemIDs.length;
    }

    @Override
    public int getNumUsers() {
        return this.userIDs.length;
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID) {
        FastIDSet userIDs1 = this.preferenceForItems.get(itemID);
        return userIDs1 == null ? 0 : userIDs1.size();
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) {
        FastIDSet userIDs1 = this.preferenceForItems.get(itemID1);
        if (userIDs1 == null) {
            return 0;
        }
        FastIDSet userIDs2 = this.preferenceForItems.get(itemID2);
        if (userIDs2 == null) {
            return 0;
        }
        return userIDs1.size() < userIDs2.size() ? userIDs2.intersectionSize(userIDs1) : userIDs1.intersectionSize(userIDs2);
    }

    @Override
    public void removePreference(long userID, long itemID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPreference(long userID, long itemID, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }

    @Override
    public boolean hasPreferenceValues() {
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("GenericBooleanPrefDataModel[users:");
        for (int i = 0; i < Math.min(3, this.userIDs.length); ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.userIDs[i]);
        }
        if (this.userIDs.length > 3) {
            result.append("...");
        }
        result.append(']');
        return result.toString();
    }
}

