/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli;

import com.lexicalscope.jewel.JewelRuntimeException;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.ValidationFailureImpl;
import com.lexicalscope.jewel.cli.ValidationFailureType;
import com.lexicalscope.jewel.cli.specification.OptionSpecification;
import com.lexicalscope.jewel.cli.specification.SpecificationMultiplicity;
import java.util.List;

class ValidationFailureWrongNumberOfValues
extends ValidationFailureImpl {
    private static final long serialVersionUID = -7899339429456035393L;
    private final OptionSpecification specification;
    private final List<String> values;

    public ValidationFailureWrongNumberOfValues(OptionSpecification specification, List<String> values) {
        super(specification, ValidationFailureWrongNumberOfValues.formatMessage(specification, values));
        this.specification = specification;
        this.values = values;
    }

    private static String formatMessage(final OptionSpecification specification, final List<String> values) {
        return specification.compareCountToSpecification(values.size(), new SpecificationMultiplicity<String>(){

            @Override
            public String expectedNoneGotSome() {
                if (values.size() == 1) {
                    return String.format(ArgumentValidationException.m_messages.getString("validationError.UnexpectedValue"), values.get(0));
                }
                return String.format(ArgumentValidationException.m_messages.getString("validationError.UnexpectedValues"), values);
            }

            @Override
            public String expectedOneGotNone() {
                return String.format(ArgumentValidationException.m_messages.getString("validationError.MissingValue"), new Object[0]);
            }

            @Override
            public String expectedOneGotSome() {
                return String.format(ArgumentValidationException.m_messages.getString("validationError.AdditionalValue"), values.subList(1, values.size()));
            }

            @Override
            public String expectedExactGotTooFew(int exactly, int valueCount) {
                if (exactly == 1) {
                    return String.format(ArgumentValidationException.m_messages.getString("validationError.LessValueThanExactly"), exactly, values);
                }
                return String.format(ArgumentValidationException.m_messages.getString("validationError.LessValuesThanExactly"), exactly, values);
            }

            @Override
            public String expectedExactGotTooMany(int exactly, int valueCount) {
                List subList = values.subList(exactly, values.size());
                if (exactly == 1) {
                    return String.format(ArgumentValidationException.m_messages.getString("validationError.MoreValueThanExactly"), exactly, subList);
                }
                return String.format(ArgumentValidationException.m_messages.getString("validationError.MoreValuesThanExactly"), exactly, subList);
            }

            @Override
            public String expectedMinimumGotTooFew(int minimum, int valueCount) {
                if (minimum == 1) {
                    return String.format(ArgumentValidationException.m_messages.getString("validationError.LessValueThanMinimum"), minimum, values);
                }
                return String.format(ArgumentValidationException.m_messages.getString("validationError.LessValuesThanMinimum"), minimum, values);
            }

            @Override
            public String expectedMaximumGotTooMany(int maximum, int valueCount) {
                List subList = values.subList(maximum, values.size());
                if (maximum == 1) {
                    return String.format(ArgumentValidationException.m_messages.getString("validationError.MoreValueThanMaximum"), maximum, subList);
                }
                return String.format(ArgumentValidationException.m_messages.getString("validationError.MoreValuesThanMaximum"), maximum, subList);
            }

            @Override
            public String allowed() {
                throw new JewelRuntimeException("unable to determine why the number of values is wrong " + specification + " with values (" + values.size() + ")");
            }
        });
    }

    @Override
    public ValidationFailureType getFailureType() {
        return this.specification.compareCountToSpecification(this.values.size(), new SpecificationMultiplicity<ValidationFailureType>(){

            @Override
            public ValidationFailureType expectedNoneGotSome() {
                return ValidationFailureType.UnexpectedValue;
            }

            @Override
            public ValidationFailureType expectedOneGotNone() {
                return ValidationFailureType.MissingValue;
            }

            @Override
            public ValidationFailureType expectedOneGotSome() {
                return ValidationFailureType.UnexpectedAdditionalValue;
            }

            @Override
            public ValidationFailureType expectedExactGotTooFew(int exactly, int valueCount) {
                return ValidationFailureType.TooFewValues;
            }

            @Override
            public ValidationFailureType expectedExactGotTooMany(int exactly, int valueCount) {
                return ValidationFailureType.TooManyValues;
            }

            @Override
            public ValidationFailureType expectedMinimumGotTooFew(int minimum, int valueCount) {
                return ValidationFailureType.TooFewValues;
            }

            @Override
            public ValidationFailureType expectedMaximumGotTooMany(int maximum, int valueCount) {
                return ValidationFailureType.TooManyValues;
            }

            @Override
            public ValidationFailureType allowed() {
                throw new JewelRuntimeException("unable to determine why the number of values is wrong " + ValidationFailureWrongNumberOfValues.this.specification + " with values (" + ValidationFailureWrongNumberOfValues.this.values.size() + ")");
            }
        });
    }
}

