/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import org.apache.commons.math3.util.FastMath;

public final class SimpleVectorMath {
    private SimpleVectorMath() {
    }

    public static double dot(float[] x, float[] y) {
        int length = x.length;
        double dot = 0.0;
        for (int i = 0; i < length; ++i) {
            dot += (double)(x[i] * y[i]);
        }
        return dot;
    }

    public static double norm(float[] x) {
        double total = 0.0;
        for (float f : x) {
            total += (double)(f * f);
        }
        return FastMath.sqrt(total);
    }

    public static double norm(double[] x) {
        double total = 0.0;
        for (double d : x) {
            total += d * d;
        }
        return FastMath.sqrt(total);
    }

    public static double distanceSquared(float[] x, float[] y) {
        int length = x.length;
        double total = 0.0;
        for (int i = 0; i < length; ++i) {
            double d = x[i] - y[i];
            total += d * d;
        }
        return total;
    }

    public static void normalize(float[] x) {
        float norm = (float)SimpleVectorMath.norm(x);
        int i = 0;
        while (i < x.length) {
            int n = i++;
            x[n] = x[n] / norm;
        }
    }
}

