/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.TasteException;

public abstract class AbstractClusterServlet
extends AbstractMyrrixServlet {
    protected abstract boolean isUser();

    @Override
    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block13: {
            String countOrN;
            String pathInfo = request.getPathInfo();
            if (pathInfo == null) {
                response.sendError(400, "No path");
            }
            Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
            try {
                countOrN = pathComponents.next();
            }
            catch (NoSuchElementException nsee) {
                response.sendError(400, nsee.toString());
                return;
            }
            if (pathComponents.hasNext()) {
                response.sendError(400, "Path too long");
                return;
            }
            MyrrixRecommender recommender = this.getRecommender();
            try {
                int n;
                if ("count".equals(countOrN)) {
                    int count = this.isUser() ? recommender.getNumUserClusters() : recommender.getNumItemClusters();
                    response.getWriter().println(count);
                    break block13;
                }
                try {
                    n = Integer.parseInt(countOrN);
                }
                catch (NumberFormatException nfe) {
                    response.sendError(400, nfe.toString());
                    return;
                }
                try {
                    FastIDSet ids = this.isUser() ? recommender.getUserCluster(n) : recommender.getItemCluster(n);
                    this.outputIDs(request, response, ids);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    response.sendError(400, ioobe.toString());
                }
            }
            catch (UnsupportedOperationException uoe) {
                response.sendError(501, uoe.toString());
            }
            catch (NotReadyException nre) {
                response.sendError(503, nre.toString());
            }
            catch (TasteException te) {
                response.sendError(500, te.toString());
                this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
            }
        }
    }
}

