/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.slopeone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.math.Varint;

public final class FullRunningAverageAndStdDevWritable
implements Writable {
    private FullRunningAverageAndStdDev average;

    public FullRunningAverageAndStdDevWritable(FullRunningAverageAndStdDev average) {
        this.average = average;
    }

    public FullRunningAverageAndStdDev getAverage() {
        return this.average;
    }

    public String toString() {
        return "" + this.average.getAverage() + '\t' + this.average.getCount() + '\t' + this.average.getMk() + '\t' + this.average.getSk();
    }

    public void write(DataOutput dataOutput) throws IOException {
        Varint.writeUnsignedVarInt(this.average.getCount(), dataOutput);
        dataOutput.writeDouble(this.average.getAverage());
        dataOutput.writeDouble(this.average.getMk());
        dataOutput.writeDouble(this.average.getSk());
    }

    public void readFields(DataInput dataInput) throws IOException {
        int count = Varint.readUnsignedVarInt(dataInput);
        double diff = dataInput.readDouble();
        double mk = dataInput.readDouble();
        double sk = dataInput.readDouble();
        this.average = new FullRunningAverageAndStdDev(count, diff, mk, sk);
    }
}

