% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_missings.R
\name{simulate_missings}
\alias{simulate_missings}
\title{Generate MCAR missings in dataset.}
\usage{
simulate_missings(
  df,
  per_missings,
  per_instances_missings = NULL,
  per_variables_missings = NULL,
  variables_with_missings = NULL
)
}
\arguments{
\item{df}{Data.frame or data.table where missing values will be generated}

\item{per_missings}{Overall percentage of missing values generated in dataset. Must be set every time.}

\item{per_instances_missings}{Percentage of instances which will have missing values.}

\item{per_variables_missings}{Percentage of variables which will have missing values.}

\item{variables_with_missings}{Only when `per_variables_missings` is `NULL`.
Vector of column indexes where missings will be generated.}
}
\value{
Dataset with generated missings.
}
\description{
Function generates random missing values in given dataset
according to set parameters.
}
\examples{
{
  data_NA <- simulate_missings(iris, 20)

  # check
  sum(is.na(data_NA)) > 0
}
}
